package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * MessagePublicationRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MessagePublicationRequest {

  private String name;

  private String correlationKey = "";

  private Long timeToLive = 0l;

  private String messageId = null;

  @Valid
  private Map<String, Object> variables;

  private String tenantId = null;

  public MessagePublicationRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MessagePublicationRequest(String name, String correlationKey) {
    this.name = name;
    this.correlationKey = correlationKey;
  }

  public MessagePublicationRequest name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the message.
   * @return name
   */
  @NotNull 
  @Schema(name = "name", description = "The name of the message.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public MessagePublicationRequest correlationKey(String correlationKey) {
    this.correlationKey = correlationKey;
    return this;
  }

  /**
   * The correlation key of the message.
   * @return correlationKey
   */
  @NotNull 
  @Schema(name = "correlationKey", description = "The correlation key of the message.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("correlationKey")
  public String getCorrelationKey() {
    return correlationKey;
  }

  public void setCorrelationKey(String correlationKey) {
    this.correlationKey = correlationKey;
  }

  public MessagePublicationRequest timeToLive(Long timeToLive) {
    this.timeToLive = timeToLive;
    return this;
  }

  /**
   * Timespan (in ms) to buffer the message on the broker.
   * @return timeToLive
   */
  
  @Schema(name = "timeToLive", description = "Timespan (in ms) to buffer the message on the broker.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("timeToLive")
  public Long getTimeToLive() {
    return timeToLive;
  }

  public void setTimeToLive(Long timeToLive) {
    this.timeToLive = timeToLive;
  }

  public MessagePublicationRequest messageId(String messageId) {
    this.messageId = messageId;
    return this;
  }

  /**
   * The unique ID of the message. Only useful to ensure only one message with the given ID will ever be published (during its lifetime). 
   * @return messageId
   */
  
  @Schema(name = "messageId", description = "The unique ID of the message. Only useful to ensure only one message with the given ID will ever be published (during its lifetime). ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("messageId")
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public MessagePublicationRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public MessagePublicationRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The message variables as JSON document.
   * @return variables
   */
  
  @Schema(name = "variables", description = "The message variables as JSON document.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public MessagePublicationRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant of the message sender.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant of the message sender.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessagePublicationRequest messagePublicationRequest = (MessagePublicationRequest) o;
    return Objects.equals(this.name, messagePublicationRequest.name) &&
        Objects.equals(this.correlationKey, messagePublicationRequest.correlationKey) &&
        Objects.equals(this.timeToLive, messagePublicationRequest.timeToLive) &&
        Objects.equals(this.messageId, messagePublicationRequest.messageId) &&
        Objects.equals(this.variables, messagePublicationRequest.variables) &&
        Objects.equals(this.tenantId, messagePublicationRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, correlationKey, timeToLive, messageId, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessagePublicationRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    correlationKey: ").append(toIndentedString(correlationKey)).append("\n");
    sb.append("    timeToLive: ").append(toIndentedString(timeToLive)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

