package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The message key of the correlated message, as well as the first process instance key it correlated with. 
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "MessageCorrelationResponse", description = "The message key of the correlated message, as well as the first process instance key it correlated with. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MessageCorrelationResponse {

  private Long messageKey;

  private String tenantId;

  private Long processInstanceKey;

  public MessageCorrelationResponse messageKey(Long messageKey) {
    this.messageKey = messageKey;
    return this;
  }

  /**
   * The key of the correlated message
   * @return messageKey
   */
  
  @Schema(name = "messageKey", description = "The key of the correlated message", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("messageKey")
  public Long getMessageKey() {
    return messageKey;
  }

  public void setMessageKey(Long messageKey) {
    this.messageKey = messageKey;
  }

  public MessageCorrelationResponse tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the correlated message
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the correlated message", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public MessageCorrelationResponse processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of the first process instance the message correlated with
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", description = "The key of the first process instance the message correlated with", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageCorrelationResponse messageCorrelationResponse = (MessageCorrelationResponse) o;
    return Objects.equals(this.messageKey, messageCorrelationResponse.messageKey) &&
        Objects.equals(this.tenantId, messageCorrelationResponse.tenantId) &&
        Objects.equals(this.processInstanceKey, messageCorrelationResponse.processInstanceKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messageKey, tenantId, processInstanceKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageCorrelationResponse {\n");
    sb.append("    messageKey: ").append(toIndentedString(messageKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

