package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * MessageCorrelationRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MessageCorrelationRequest {

  private String name;

  private String correlationKey = "";

  @Valid
  private Map<String, Object> variables;

  private String tenantId = null;

  public MessageCorrelationRequest name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The message name as defined in the BPMN process 
   * @return name
   */
  
  @Schema(name = "name", description = "The message name as defined in the BPMN process ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public MessageCorrelationRequest correlationKey(String correlationKey) {
    this.correlationKey = correlationKey;
    return this;
  }

  /**
   * The correlation key of the message
   * @return correlationKey
   */
  
  @Schema(name = "correlationKey", description = "The correlation key of the message", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("correlationKey")
  public String getCorrelationKey() {
    return correlationKey;
  }

  public void setCorrelationKey(String correlationKey) {
    this.correlationKey = correlationKey;
  }

  public MessageCorrelationRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public MessageCorrelationRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The message variables as JSON document
   * @return variables
   */
  
  @Schema(name = "variables", description = "The message variables as JSON document", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public MessageCorrelationRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * the tenant for which the message is published
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "the tenant for which the message is published", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MessageCorrelationRequest messageCorrelationRequest = (MessageCorrelationRequest) o;
    return Objects.equals(this.name, messageCorrelationRequest.name) &&
        Objects.equals(this.correlationKey, messageCorrelationRequest.correlationKey) &&
        Objects.equals(this.variables, messageCorrelationRequest.variables) &&
        Objects.equals(this.tenantId, messageCorrelationRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, correlationKey, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MessageCorrelationRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    correlationKey: ").append(toIndentedString(correlationKey)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

