package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionOutputItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The decision rules that matched within this decision evaluation.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "MatchedDecisionRuleItem", description = "The decision rules that matched within this decision evaluation.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class MatchedDecisionRuleItem {

  private String ruleId;

  private Integer ruleIndex;

  @Valid
  private List<@Valid EvaluatedDecisionOutputItem> evaluatedOutputs = new ArrayList<>();

  public MatchedDecisionRuleItem ruleId(String ruleId) {
    this.ruleId = ruleId;
    return this;
  }

  /**
   * The ID of the matched rule.
   * @return ruleId
   */
  
  @Schema(name = "ruleId", description = "The ID of the matched rule.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("ruleId")
  public String getRuleId() {
    return ruleId;
  }

  public void setRuleId(String ruleId) {
    this.ruleId = ruleId;
  }

  public MatchedDecisionRuleItem ruleIndex(Integer ruleIndex) {
    this.ruleIndex = ruleIndex;
    return this;
  }

  /**
   * The index of the matched rule.
   * @return ruleIndex
   */
  
  @Schema(name = "ruleIndex", description = "The index of the matched rule.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("ruleIndex")
  public Integer getRuleIndex() {
    return ruleIndex;
  }

  public void setRuleIndex(Integer ruleIndex) {
    this.ruleIndex = ruleIndex;
  }

  public MatchedDecisionRuleItem evaluatedOutputs(List<@Valid EvaluatedDecisionOutputItem> evaluatedOutputs) {
    this.evaluatedOutputs = evaluatedOutputs;
    return this;
  }

  public MatchedDecisionRuleItem addEvaluatedOutputsItem(EvaluatedDecisionOutputItem evaluatedOutputsItem) {
    if (this.evaluatedOutputs == null) {
      this.evaluatedOutputs = new ArrayList<>();
    }
    this.evaluatedOutputs.add(evaluatedOutputsItem);
    return this;
  }

  /**
   * Get evaluatedOutputs
   * @return evaluatedOutputs
   */
  @Valid 
  @Schema(name = "evaluatedOutputs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("evaluatedOutputs")
  public List<@Valid EvaluatedDecisionOutputItem> getEvaluatedOutputs() {
    return evaluatedOutputs;
  }

  public void setEvaluatedOutputs(List<@Valid EvaluatedDecisionOutputItem> evaluatedOutputs) {
    this.evaluatedOutputs = evaluatedOutputs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MatchedDecisionRuleItem matchedDecisionRuleItem = (MatchedDecisionRuleItem) o;
    return Objects.equals(this.ruleId, matchedDecisionRuleItem.ruleId) &&
        Objects.equals(this.ruleIndex, matchedDecisionRuleItem.ruleIndex) &&
        Objects.equals(this.evaluatedOutputs, matchedDecisionRuleItem.evaluatedOutputs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ruleId, ruleIndex, evaluatedOutputs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MatchedDecisionRuleItem {\n");
    sb.append("    ruleId: ").append(toIndentedString(ruleId)).append("\n");
    sb.append("    ruleIndex: ").append(toIndentedString(ruleIndex)).append("\n");
    sb.append("    evaluatedOutputs: ").append(toIndentedString(evaluatedOutputs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

