package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The response of a license request.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "LicenseResponse", description = "The response of a license request.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class LicenseResponse {

  private Boolean validLicense;

  private String licenseType;

  public LicenseResponse validLicense(Boolean validLicense) {
    this.validLicense = validLicense;
    return this;
  }

  /**
   * True if the Camunda license is valid, false if otherwise
   * @return validLicense
   */
  
  @Schema(name = "validLicense", description = "True if the Camunda license is valid, false if otherwise", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("validLicense")
  public Boolean getValidLicense() {
    return validLicense;
  }

  public void setValidLicense(Boolean validLicense) {
    this.validLicense = validLicense;
  }

  public LicenseResponse licenseType(String licenseType) {
    this.licenseType = licenseType;
    return this;
  }

  /**
   * Will return the license type property of the Camunda license
   * @return licenseType
   */
  
  @Schema(name = "licenseType", description = "Will return the license type property of the Camunda license", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("licenseType")
  public String getLicenseType() {
    return licenseType;
  }

  public void setLicenseType(String licenseType) {
    this.licenseType = licenseType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseResponse licenseResponse = (LicenseResponse) o;
    return Objects.equals(this.validLicense, licenseResponse.validLicense) &&
        Objects.equals(this.licenseType, licenseResponse.licenseType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validLicense, licenseType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LicenseResponse {\n");
    sb.append("    validLicense: ").append(toIndentedString(validLicense)).append("\n");
    sb.append("    licenseType: ").append(toIndentedString(licenseType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

