package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * JobFailRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class JobFailRequest {

  private Integer retries = 0;

  private String errorMessage = null;

  private Long retryBackOff = 0l;

  @Valid
  private Map<String, Object> variables;

  public JobFailRequest retries(Integer retries) {
    this.retries = retries;
    return this;
  }

  /**
   * The amount of retries the job should have left 
   * @return retries
   */
  
  @Schema(name = "retries", description = "The amount of retries the job should have left ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("retries")
  public Integer getRetries() {
    return retries;
  }

  public void setRetries(Integer retries) {
    this.retries = retries;
  }

  public JobFailRequest errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * An optional message describing why the job failed. This is particularly useful if a job runs out of retries and an incident is raised, as this message can help explain why an incident was raised. 
   * @return errorMessage
   */
  
  @Schema(name = "errorMessage", description = "An optional message describing why the job failed. This is particularly useful if a job runs out of retries and an incident is raised, as this message can help explain why an incident was raised. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public JobFailRequest retryBackOff(Long retryBackOff) {
    this.retryBackOff = retryBackOff;
    return this;
  }

  /**
   * The backoff timeout (in ms) for the next retry. 
   * @return retryBackOff
   */
  
  @Schema(name = "retryBackOff", description = "The backoff timeout (in ms) for the next retry. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("retryBackOff")
  public Long getRetryBackOff() {
    return retryBackOff;
  }

  public void setRetryBackOff(Long retryBackOff) {
    this.retryBackOff = retryBackOff;
  }

  public JobFailRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public JobFailRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON object that will instantiate the variables at the local scope of the job's associated task. 
   * @return variables
   */
  
  @Schema(name = "variables", description = "JSON object that will instantiate the variables at the local scope of the job's associated task. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobFailRequest jobFailRequest = (JobFailRequest) o;
    return Objects.equals(this.retries, jobFailRequest.retries) &&
        Objects.equals(this.errorMessage, jobFailRequest.errorMessage) &&
        Objects.equals(this.retryBackOff, jobFailRequest.retryBackOff) &&
        Objects.equals(this.variables, jobFailRequest.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(retries, errorMessage, retryBackOff, variables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobFailRequest {\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    retryBackOff: ").append(toIndentedString(retryBackOff)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

