package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * JobErrorRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class JobErrorRequest {

  private String errorCode;

  private String errorMessage = null;

  @Valid
  private Map<String, Object> variables;

  public JobErrorRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public JobErrorRequest(String errorCode) {
    this.errorCode = errorCode;
  }

  public JobErrorRequest errorCode(String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The error code that will be matched with an error catch event. 
   * @return errorCode
   */
  @NotNull 
  @Schema(name = "errorCode", description = "The error code that will be matched with an error catch event. ", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("errorCode")
  public String getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }

  public JobErrorRequest errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * An error message that provides additional context. 
   * @return errorMessage
   */
  
  @Schema(name = "errorMessage", description = "An error message that provides additional context. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public JobErrorRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public JobErrorRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON object that will instantiate the variables at the local scope of the error catch event that catches the thrown error. 
   * @return variables
   */
  
  @Schema(name = "variables", description = "JSON object that will instantiate the variables at the local scope of the error catch event that catches the thrown error. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobErrorRequest jobErrorRequest = (JobErrorRequest) o;
    return Objects.equals(this.errorCode, jobErrorRequest.errorCode) &&
        Objects.equals(this.errorMessage, jobErrorRequest.errorMessage) &&
        Objects.equals(this.variables, jobErrorRequest.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(errorCode, errorMessage, variables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobErrorRequest {\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

