package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * JSON object with changed job attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * &#x60;retries&#x60; - The new amount of retries for the job; must be a positive number. * &#x60;timeout&#x60; - The duration of the new timeout in ms, starting from the current moment.  Providing any of those attributes with a null value or omitting it preserves the persisted attribute’s value.  The job cannot be completed or failed with this endpoint, use the complete job or fail job endpoints instead. 
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "JobChangeset", description = "JSON object with changed job attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * `retries` - The new amount of retries for the job; must be a positive number. * `timeout` - The duration of the new timeout in ms, starting from the current moment.  Providing any of those attributes with a null value or omitting it preserves the persisted attribute’s value.  The job cannot be completed or failed with this endpoint, use the complete job or fail job endpoints instead. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class JobChangeset {

  private Integer retries = null;

  private Long timeout = null;

  public JobChangeset retries(Integer retries) {
    this.retries = retries;
    return this;
  }

  /**
   * The new amount of retries for the job; must be a positive number.
   * @return retries
   */
  
  @Schema(name = "retries", description = "The new amount of retries for the job; must be a positive number.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("retries")
  public Integer getRetries() {
    return retries;
  }

  public void setRetries(Integer retries) {
    this.retries = retries;
  }

  public JobChangeset timeout(Long timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * The duration of the new timeout in ms, starting from the current moment.
   * @return timeout
   */
  
  @Schema(name = "timeout", description = "The duration of the new timeout in ms, starting from the current moment.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("timeout")
  public Long getTimeout() {
    return timeout;
  }

  public void setTimeout(Long timeout) {
    this.timeout = timeout;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobChangeset jobChangeset = (JobChangeset) o;
    return Objects.equals(this.retries, jobChangeset.retries) &&
        Objects.equals(this.timeout, jobChangeset.timeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(retries, timeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobChangeset {\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

