package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * JobActivationRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class JobActivationRequest {

  private String type;

  private String worker = null;

  private Long timeout;

  private Integer maxJobsToActivate;

  @Valid
  private List<String> fetchVariable;

  private Long requestTimeout = null;

  @Valid
  private List<String> tenantIds;

  public JobActivationRequest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public JobActivationRequest(String type, Long timeout, Integer maxJobsToActivate) {
    this.type = type;
    this.timeout = timeout;
    this.maxJobsToActivate = maxJobsToActivate;
  }

  public JobActivationRequest type(String type) {
    this.type = type;
    return this;
  }

  /**
   * the job type, as defined in the BPMN process (e.g. <zeebe:taskDefinition type=\"payment-service\" />) 
   * @return type
   */
  @NotNull 
  @Schema(name = "type", description = "the job type, as defined in the BPMN process (e.g. <zeebe:taskDefinition type=\"payment-service\" />) ", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public JobActivationRequest worker(String worker) {
    this.worker = worker;
    return this;
  }

  /**
   * the name of the worker activating the jobs, mostly used for logging purposes
   * @return worker
   */
  
  @Schema(name = "worker", description = "the name of the worker activating the jobs, mostly used for logging purposes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("worker")
  public String getWorker() {
    return worker;
  }

  public void setWorker(String worker) {
    this.worker = worker;
  }

  public JobActivationRequest timeout(Long timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * a job returned after this call will not be activated by another call until the timeout (in ms) has been reached 
   * @return timeout
   */
  @NotNull 
  @Schema(name = "timeout", description = "a job returned after this call will not be activated by another call until the timeout (in ms) has been reached ", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("timeout")
  public Long getTimeout() {
    return timeout;
  }

  public void setTimeout(Long timeout) {
    this.timeout = timeout;
  }

  public JobActivationRequest maxJobsToActivate(Integer maxJobsToActivate) {
    this.maxJobsToActivate = maxJobsToActivate;
    return this;
  }

  /**
   * the maximum jobs to activate by this request
   * @return maxJobsToActivate
   */
  @NotNull 
  @Schema(name = "maxJobsToActivate", description = "the maximum jobs to activate by this request", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("maxJobsToActivate")
  public Integer getMaxJobsToActivate() {
    return maxJobsToActivate;
  }

  public void setMaxJobsToActivate(Integer maxJobsToActivate) {
    this.maxJobsToActivate = maxJobsToActivate;
  }

  public JobActivationRequest fetchVariable(List<String> fetchVariable) {
    this.fetchVariable = fetchVariable;
    return this;
  }

  public JobActivationRequest addFetchVariableItem(String fetchVariableItem) {
    if (this.fetchVariable == null) {
      this.fetchVariable = new ArrayList<>();
    }
    this.fetchVariable.add(fetchVariableItem);
    return this;
  }

  /**
   * a list of variables to fetch as the job variables; if empty, all visible variables at the time of activation for the scope of the job will be returned 
   * @return fetchVariable
   */
  
  @Schema(name = "fetchVariable", description = "a list of variables to fetch as the job variables; if empty, all visible variables at the time of activation for the scope of the job will be returned ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fetchVariable")
  public List<String> getFetchVariable() {
    return fetchVariable;
  }

  public void setFetchVariable(List<String> fetchVariable) {
    this.fetchVariable = fetchVariable;
  }

  public JobActivationRequest requestTimeout(Long requestTimeout) {
    this.requestTimeout = requestTimeout;
    return this;
  }

  /**
   * The request will be completed when at least one job is activated or after the requestTimeout (in ms). If the requestTimeout = 0, a default timeout is used. If the requestTimeout < 0, long polling is disabled and the request is completed immediately, even when no job is activated. 
   * @return requestTimeout
   */
  
  @Schema(name = "requestTimeout", description = "The request will be completed when at least one job is activated or after the requestTimeout (in ms). If the requestTimeout = 0, a default timeout is used. If the requestTimeout < 0, long polling is disabled and the request is completed immediately, even when no job is activated. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("requestTimeout")
  public Long getRequestTimeout() {
    return requestTimeout;
  }

  public void setRequestTimeout(Long requestTimeout) {
    this.requestTimeout = requestTimeout;
  }

  public JobActivationRequest tenantIds(List<String> tenantIds) {
    this.tenantIds = tenantIds;
    return this;
  }

  public JobActivationRequest addTenantIdsItem(String tenantIdsItem) {
    if (this.tenantIds == null) {
      this.tenantIds = new ArrayList<>();
    }
    this.tenantIds.add(tenantIdsItem);
    return this;
  }

  /**
   * a list of IDs of tenants for which to activate jobs
   * @return tenantIds
   */
  
  @Schema(name = "tenantIds", description = "a list of IDs of tenants for which to activate jobs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantIds")
  public List<String> getTenantIds() {
    return tenantIds;
  }

  public void setTenantIds(List<String> tenantIds) {
    this.tenantIds = tenantIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobActivationRequest jobActivationRequest = (JobActivationRequest) o;
    return Objects.equals(this.type, jobActivationRequest.type) &&
        Objects.equals(this.worker, jobActivationRequest.worker) &&
        Objects.equals(this.timeout, jobActivationRequest.timeout) &&
        Objects.equals(this.maxJobsToActivate, jobActivationRequest.maxJobsToActivate) &&
        Objects.equals(this.fetchVariable, jobActivationRequest.fetchVariable) &&
        Objects.equals(this.requestTimeout, jobActivationRequest.requestTimeout) &&
        Objects.equals(this.tenantIds, jobActivationRequest.tenantIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, worker, timeout, maxJobsToActivate, fetchVariable, requestTimeout, tenantIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobActivationRequest {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    maxJobsToActivate: ").append(toIndentedString(maxJobsToActivate)).append("\n");
    sb.append("    fetchVariable: ").append(toIndentedString(fetchVariable)).append("\n");
    sb.append("    requestTimeout: ").append(toIndentedString(requestTimeout)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

