package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * IncidentFilterRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class IncidentFilterRequest {

  private Long key;

  private Long processDefinitionKey;

  private String processDefinitionId;

  private Long processInstanceKey;

  /**
   * Incident error type with a defined set of values.
   */
  public enum ErrorTypeEnum {
    UNSPECIFIED("UNSPECIFIED"),
    
    UNKNOWN("UNKNOWN"),
    
    IO_MAPPING_ERROR("IO_MAPPING_ERROR"),
    
    JOB_NO_RETRIES("JOB_NO_RETRIES"),
    
    CONDITION_ERROR("CONDITION_ERROR"),
    
    EXTRACT_VALUE_ERROR("EXTRACT_VALUE_ERROR"),
    
    CALLED_ELEMENT_ERROR("CALLED_ELEMENT_ERROR"),
    
    UNHANDLED_ERROR_EVENT("UNHANDLED_ERROR_EVENT"),
    
    MESSAGE_SIZE_EXCEEDED("MESSAGE_SIZE_EXCEEDED"),
    
    CALLED_DECISION_ERROR("CALLED_DECISION_ERROR"),
    
    DECISION_EVALUATION_ERROR("DECISION_EVALUATION_ERROR"),
    
    FORM_NOT_FOUND("FORM_NOT_FOUND");

    private String value;

    ErrorTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorTypeEnum fromValue(String value) {
      for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private ErrorTypeEnum errorType;

  private String errorMessage;

  private String flowNodeId;

  private Long flowNodeInstanceKey;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String creationTime;

  /**
   * State of this incident with a defined set of values.
   */
  public enum StateEnum {
    ACTIVE("ACTIVE"),
    
    MIGRATED("MIGRATED"),
    
    RESOLVED("RESOLVED"),
    
    PENDING("PENDING");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private StateEnum state;

  private Long jobKey;

  private String treePath;

  private String tenantId;

  public IncidentFilterRequest key(Long key) {
    this.key = key;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this incident.
   * @return key
   */
  
  @Schema(name = "key", description = "The assigned key, which acts as a unique identifier for this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("key")
  public Long getKey() {
    return key;
  }

  public void setKey(Long key) {
    this.key = key;
  }

  public IncidentFilterRequest processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this incident.
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "The process definition key associated to this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public IncidentFilterRequest processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process id associated to this incident.
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", description = "The bpmn process id associated to this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public IncidentFilterRequest processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this incident.
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", description = "The process instance key associated to this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public IncidentFilterRequest errorType(ErrorTypeEnum errorType) {
    this.errorType = errorType;
    return this;
  }

  /**
   * Incident error type with a defined set of values.
   * @return errorType
   */
  
  @Schema(name = "errorType", description = "Incident error type with a defined set of values.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorType")
  public ErrorTypeEnum getErrorType() {
    return errorType;
  }

  public void setErrorType(ErrorTypeEnum errorType) {
    this.errorType = errorType;
  }

  public IncidentFilterRequest errorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Error message which describes the error in more detail.
   * @return errorMessage
   */
  
  @Schema(name = "errorMessage", description = "Error message which describes the error in more detail.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("errorMessage")
  public String getErrorMessage() {
    return errorMessage;
  }

  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IncidentFilterRequest flowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node id associated to this incident.
   * @return flowNodeId
   */
  
  @Schema(name = "flowNodeId", description = "The flow node id associated to this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("flowNodeId")
  public String getFlowNodeId() {
    return flowNodeId;
  }

  public void setFlowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public IncidentFilterRequest flowNodeInstanceKey(Long flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
    return this;
  }

  /**
   * The flow node instance key associated to this incident.
   * @return flowNodeInstanceKey
   */
  
  @Schema(name = "flowNodeInstanceKey", description = "The flow node instance key associated to this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("flowNodeInstanceKey")
  public Long getFlowNodeInstanceKey() {
    return flowNodeInstanceKey;
  }

  public void setFlowNodeInstanceKey(Long flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
  }

  public IncidentFilterRequest creationTime(String creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Date of incident creation.
   * @return creationTime
   */
  @Valid 
  @Schema(name = "creationTime", description = "Date of incident creation.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("creationTime")
  public String getCreationTime() {
    return creationTime;
  }

  public void setCreationTime(String creationTime) {
    this.creationTime = creationTime;
  }

  public IncidentFilterRequest state(StateEnum state) {
    this.state = state;
    return this;
  }

  /**
   * State of this incident with a defined set of values.
   * @return state
   */
  
  @Schema(name = "state", description = "State of this incident with a defined set of values.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }

  public void setState(StateEnum state) {
    this.state = state;
  }

  public IncidentFilterRequest jobKey(Long jobKey) {
    this.jobKey = jobKey;
    return this;
  }

  /**
   * The job key, if exists, associated with this incident.
   * @return jobKey
   */
  
  @Schema(name = "jobKey", description = "The job key, if exists, associated with this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("jobKey")
  public Long getJobKey() {
    return jobKey;
  }

  public void setJobKey(Long jobKey) {
    this.jobKey = jobKey;
  }

  public IncidentFilterRequest treePath(String treePath) {
    this.treePath = treePath;
    return this;
  }

  /**
   * The path from process instance via flow node ids and flow node instance keys leading to this incident.
   * @return treePath
   */
  
  @Schema(name = "treePath", description = "The path from process instance via flow node ids and flow node instance keys leading to this incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("treePath")
  public String getTreePath() {
    return treePath;
  }

  public void setTreePath(String treePath) {
    this.treePath = treePath;
  }

  public IncidentFilterRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the incident.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant id of the incident.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentFilterRequest incidentFilterRequest = (IncidentFilterRequest) o;
    return Objects.equals(this.key, incidentFilterRequest.key) &&
        Objects.equals(this.processDefinitionKey, incidentFilterRequest.processDefinitionKey) &&
        Objects.equals(this.processDefinitionId, incidentFilterRequest.processDefinitionId) &&
        Objects.equals(this.processInstanceKey, incidentFilterRequest.processInstanceKey) &&
        Objects.equals(this.errorType, incidentFilterRequest.errorType) &&
        Objects.equals(this.errorMessage, incidentFilterRequest.errorMessage) &&
        Objects.equals(this.flowNodeId, incidentFilterRequest.flowNodeId) &&
        Objects.equals(this.flowNodeInstanceKey, incidentFilterRequest.flowNodeInstanceKey) &&
        Objects.equals(this.creationTime, incidentFilterRequest.creationTime) &&
        Objects.equals(this.state, incidentFilterRequest.state) &&
        Objects.equals(this.jobKey, incidentFilterRequest.jobKey) &&
        Objects.equals(this.treePath, incidentFilterRequest.treePath) &&
        Objects.equals(this.tenantId, incidentFilterRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, processDefinitionKey, processDefinitionId, processInstanceKey, errorType, errorMessage, flowNodeId, flowNodeInstanceKey, creationTime, state, jobKey, treePath, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentFilterRequest {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    flowNodeInstanceKey: ").append(toIndentedString(flowNodeInstanceKey)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    treePath: ").append(toIndentedString(treePath)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

