package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * FlowNodeInstanceFilterRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class FlowNodeInstanceFilterRequest {

  private Long flowNodeInstanceKey;

  private Long processInstanceKey;

  private Long processDefinitionKey;

  private String state;

  private String type;

  private String flowNodeId;

  private String flowNodeName;

  private String treePath;

  private Boolean incident;

  private Long incidentKey;

  private String tenantId;

  public FlowNodeInstanceFilterRequest flowNodeInstanceKey(Long flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
    return this;
  }

  /**
   * The key of this flow node instance.
   * @return flowNodeInstanceKey
   */
  
  @Schema(name = "flowNodeInstanceKey", description = "The key of this flow node instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("flowNodeInstanceKey")
  public Long getFlowNodeInstanceKey() {
    return flowNodeInstanceKey;
  }

  public void setFlowNodeInstanceKey(Long flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
  }

  public FlowNodeInstanceFilterRequest processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key.
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", description = "The process instance key.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public FlowNodeInstanceFilterRequest processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key.
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "The process definition key.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public FlowNodeInstanceFilterRequest state(String state) {
    this.state = state;
    return this;
  }

  /**
   * The state, one of ACTIVE, COMPLETED, TERMINATED.
   * @return state
   */
  
  @Schema(name = "state", description = "The state, one of ACTIVE, COMPLETED, TERMINATED.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public FlowNodeInstanceFilterRequest type(String type) {
    this.type = type;
    return this;
  }

  /**
   * The flow node type
   * @return type
   */
  
  @Schema(name = "type", description = "The flow node type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public FlowNodeInstanceFilterRequest flowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node id
   * @return flowNodeId
   */
  
  @Schema(name = "flowNodeId", description = "The flow node id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("flowNodeId")
  public String getFlowNodeId() {
    return flowNodeId;
  }

  public void setFlowNodeId(String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public FlowNodeInstanceFilterRequest flowNodeName(String flowNodeName) {
    this.flowNodeName = flowNodeName;
    return this;
  }

  /**
   * The flow node name
   * @return flowNodeName
   */
  
  @Schema(name = "flowNodeName", description = "The flow node name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("flowNodeName")
  public String getFlowNodeName() {
    return flowNodeName;
  }

  public void setFlowNodeName(String flowNodeName) {
    this.flowNodeName = flowNodeName;
  }

  public FlowNodeInstanceFilterRequest treePath(String treePath) {
    this.treePath = treePath;
    return this;
  }

  /**
   * The path of keys from process instance to this flow node instance separated by '/'
   * @return treePath
   */
  
  @Schema(name = "treePath", description = "The path of keys from process instance to this flow node instance separated by '/'", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("treePath")
  public String getTreePath() {
    return treePath;
  }

  public void setTreePath(String treePath) {
    this.treePath = treePath;
  }

  public FlowNodeInstanceFilterRequest incident(Boolean incident) {
    this.incident = incident;
    return this;
  }

  /**
   * Shows whether this flow node instance has an incident related to
   * @return incident
   */
  
  @Schema(name = "incident", description = "Shows whether this flow node instance has an incident related to", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("incident")
  public Boolean getIncident() {
    return incident;
  }

  public void setIncident(Boolean incident) {
    this.incident = incident;
  }

  public FlowNodeInstanceFilterRequest incidentKey(Long incidentKey) {
    this.incidentKey = incidentKey;
    return this;
  }

  /**
   * The key of incident if field incident is true
   * @return incidentKey
   */
  
  @Schema(name = "incidentKey", description = "The key of incident if field incident is true", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("incidentKey")
  public Long getIncidentKey() {
    return incidentKey;
  }

  public void setIncidentKey(Long incidentKey) {
    this.incidentKey = incidentKey;
  }

  public FlowNodeInstanceFilterRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FlowNodeInstanceFilterRequest flowNodeInstanceFilterRequest = (FlowNodeInstanceFilterRequest) o;
    return Objects.equals(this.flowNodeInstanceKey, flowNodeInstanceFilterRequest.flowNodeInstanceKey) &&
        Objects.equals(this.processInstanceKey, flowNodeInstanceFilterRequest.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, flowNodeInstanceFilterRequest.processDefinitionKey) &&
        Objects.equals(this.state, flowNodeInstanceFilterRequest.state) &&
        Objects.equals(this.type, flowNodeInstanceFilterRequest.type) &&
        Objects.equals(this.flowNodeId, flowNodeInstanceFilterRequest.flowNodeId) &&
        Objects.equals(this.flowNodeName, flowNodeInstanceFilterRequest.flowNodeName) &&
        Objects.equals(this.treePath, flowNodeInstanceFilterRequest.treePath) &&
        Objects.equals(this.incident, flowNodeInstanceFilterRequest.incident) &&
        Objects.equals(this.incidentKey, flowNodeInstanceFilterRequest.incidentKey) &&
        Objects.equals(this.tenantId, flowNodeInstanceFilterRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(flowNodeInstanceKey, processInstanceKey, processDefinitionKey, state, type, flowNodeId, flowNodeName, treePath, incident, incidentKey, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FlowNodeInstanceFilterRequest {\n");
    sb.append("    flowNodeInstanceKey: ").append(toIndentedString(flowNodeInstanceKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    flowNodeName: ").append(toIndentedString(flowNodeName)).append("\n");
    sb.append("    treePath: ").append(toIndentedString(treePath)).append("\n");
    sb.append("    incident: ").append(toIndentedString(incident)).append("\n");
    sb.append("    incidentKey: ").append(toIndentedString(incidentKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

