package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The evaluated decision outputs.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "EvaluatedDecisionOutputItem", description = "The evaluated decision outputs.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluatedDecisionOutputItem {

  private String outputId;

  private String outputName;

  private String outputValue;

  public EvaluatedDecisionOutputItem outputId(String outputId) {
    this.outputId = outputId;
    return this;
  }

  /**
   * The ID of the evaluated decision output.
   * @return outputId
   */
  
  @Schema(name = "outputId", description = "The ID of the evaluated decision output.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("outputId")
  public String getOutputId() {
    return outputId;
  }

  public void setOutputId(String outputId) {
    this.outputId = outputId;
  }

  public EvaluatedDecisionOutputItem outputName(String outputName) {
    this.outputName = outputName;
    return this;
  }

  /**
   * The name of the evaluated decision output.
   * @return outputName
   */
  
  @Schema(name = "outputName", description = "The name of the evaluated decision output.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("outputName")
  public String getOutputName() {
    return outputName;
  }

  public void setOutputName(String outputName) {
    this.outputName = outputName;
  }

  public EvaluatedDecisionOutputItem outputValue(String outputValue) {
    this.outputValue = outputValue;
    return this;
  }

  /**
   * The value of the evaluated decision output.
   * @return outputValue
   */
  
  @Schema(name = "outputValue", description = "The value of the evaluated decision output.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("outputValue")
  public String getOutputValue() {
    return outputValue;
  }

  public void setOutputValue(String outputValue) {
    this.outputValue = outputValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluatedDecisionOutputItem evaluatedDecisionOutputItem = (EvaluatedDecisionOutputItem) o;
    return Objects.equals(this.outputId, evaluatedDecisionOutputItem.outputId) &&
        Objects.equals(this.outputName, evaluatedDecisionOutputItem.outputName) &&
        Objects.equals(this.outputValue, evaluatedDecisionOutputItem.outputValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(outputId, outputName, outputValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluatedDecisionOutputItem {\n");
    sb.append("    outputId: ").append(toIndentedString(outputId)).append("\n");
    sb.append("    outputName: ").append(toIndentedString(outputName)).append("\n");
    sb.append("    outputValue: ").append(toIndentedString(outputValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

