package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.zeebe.gateway.protocol.rest.MatchedDecisionRuleItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * List of decisions that were evaluated within the requested decision evaluation.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "EvaluatedDecisionItem", description = "List of decisions that were evaluated within the requested decision evaluation.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluatedDecisionItem {

  private Long decisionDefinitionKey;

  private String decisionDefinitionId;

  private String decisionDefinitionName;

  private Integer decisionDefinitionVersion;

  private String decisionDefinitionType;

  private String output;

  private String tenantId;

  @Valid
  private List<@Valid MatchedDecisionRuleItem> matchedRules = new ArrayList<>();

  @Valid
  private List<@Valid EvaluatedDecisionInputItem> evaluatedInputs = new ArrayList<>();

  public EvaluatedDecisionItem decisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the decision which was evaluate.
   * @return decisionDefinitionKey
   */
  
  @Schema(name = "decisionDefinitionKey", description = "The unique key identifying the decision which was evaluate.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionKey")
  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public EvaluatedDecisionItem decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which was evaluated.
   * @return decisionDefinitionId
   */
  
  @Schema(name = "decisionDefinitionId", description = "The ID of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionId")
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public EvaluatedDecisionItem decisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the decision which was evaluated.
   * @return decisionDefinitionName
   */
  
  @Schema(name = "decisionDefinitionName", description = "The name of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionName")
  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }

  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public EvaluatedDecisionItem decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision which was evaluated.
   * @return decisionDefinitionVersion
   */
  
  @Schema(name = "decisionDefinitionVersion", description = "The version of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionVersion")
  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }

  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public EvaluatedDecisionItem decisionDefinitionType(String decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
    return this;
  }

  /**
   * The type of the decision which was evaluated.
   * @return decisionDefinitionType
   */
  
  @Schema(name = "decisionDefinitionType", description = "The type of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionType")
  public String getDecisionDefinitionType() {
    return decisionDefinitionType;
  }

  public void setDecisionDefinitionType(String decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
  }

  public EvaluatedDecisionItem output(String output) {
    this.output = output;
    return this;
  }

  /**
   * JSON document that will instantiate the result of the decision which was evaluated. 
   * @return output
   */
  
  @Schema(name = "output", description = "JSON document that will instantiate the result of the decision which was evaluated. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("output")
  public String getOutput() {
    return output;
  }

  public void setOutput(String output) {
    this.output = output;
  }

  public EvaluatedDecisionItem tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the evaluated decision.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the evaluated decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public EvaluatedDecisionItem matchedRules(List<@Valid MatchedDecisionRuleItem> matchedRules) {
    this.matchedRules = matchedRules;
    return this;
  }

  public EvaluatedDecisionItem addMatchedRulesItem(MatchedDecisionRuleItem matchedRulesItem) {
    if (this.matchedRules == null) {
      this.matchedRules = new ArrayList<>();
    }
    this.matchedRules.add(matchedRulesItem);
    return this;
  }

  /**
   * Get matchedRules
   * @return matchedRules
   */
  @Valid 
  @Schema(name = "matchedRules", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("matchedRules")
  public List<@Valid MatchedDecisionRuleItem> getMatchedRules() {
    return matchedRules;
  }

  public void setMatchedRules(List<@Valid MatchedDecisionRuleItem> matchedRules) {
    this.matchedRules = matchedRules;
  }

  public EvaluatedDecisionItem evaluatedInputs(List<@Valid EvaluatedDecisionInputItem> evaluatedInputs) {
    this.evaluatedInputs = evaluatedInputs;
    return this;
  }

  public EvaluatedDecisionItem addEvaluatedInputsItem(EvaluatedDecisionInputItem evaluatedInputsItem) {
    if (this.evaluatedInputs == null) {
      this.evaluatedInputs = new ArrayList<>();
    }
    this.evaluatedInputs.add(evaluatedInputsItem);
    return this;
  }

  /**
   * Get evaluatedInputs
   * @return evaluatedInputs
   */
  @Valid 
  @Schema(name = "evaluatedInputs", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("evaluatedInputs")
  public List<@Valid EvaluatedDecisionInputItem> getEvaluatedInputs() {
    return evaluatedInputs;
  }

  public void setEvaluatedInputs(List<@Valid EvaluatedDecisionInputItem> evaluatedInputs) {
    this.evaluatedInputs = evaluatedInputs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluatedDecisionItem evaluatedDecisionItem = (EvaluatedDecisionItem) o;
    return Objects.equals(this.decisionDefinitionKey, evaluatedDecisionItem.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionId, evaluatedDecisionItem.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, evaluatedDecisionItem.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, evaluatedDecisionItem.decisionDefinitionVersion) &&
        Objects.equals(this.decisionDefinitionType, evaluatedDecisionItem.decisionDefinitionType) &&
        Objects.equals(this.output, evaluatedDecisionItem.output) &&
        Objects.equals(this.tenantId, evaluatedDecisionItem.tenantId) &&
        Objects.equals(this.matchedRules, evaluatedDecisionItem.matchedRules) &&
        Objects.equals(this.evaluatedInputs, evaluatedDecisionItem.evaluatedInputs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionKey, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionDefinitionType, output, tenantId, matchedRules, evaluatedInputs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluatedDecisionItem {\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionDefinitionType: ").append(toIndentedString(decisionDefinitionType)).append("\n");
    sb.append("    output: ").append(toIndentedString(output)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    matchedRules: ").append(toIndentedString(matchedRules)).append("\n");
    sb.append("    evaluatedInputs: ").append(toIndentedString(evaluatedInputs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

