package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * The decision inputs that were evaluated within this decision evaluation.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "EvaluatedDecisionInputItem", description = "The decision inputs that were evaluated within this decision evaluation.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluatedDecisionInputItem {

  private String inputId;

  private String inputName;

  private String inputValue;

  public EvaluatedDecisionInputItem inputId(String inputId) {
    this.inputId = inputId;
    return this;
  }

  /**
   * The ID of the evaluated decision input.
   * @return inputId
   */
  
  @Schema(name = "inputId", description = "The ID of the evaluated decision input.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputId")
  public String getInputId() {
    return inputId;
  }

  public void setInputId(String inputId) {
    this.inputId = inputId;
  }

  public EvaluatedDecisionInputItem inputName(String inputName) {
    this.inputName = inputName;
    return this;
  }

  /**
   * The name of the evaluated decision input.
   * @return inputName
   */
  
  @Schema(name = "inputName", description = "The name of the evaluated decision input.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputName")
  public String getInputName() {
    return inputName;
  }

  public void setInputName(String inputName) {
    this.inputName = inputName;
  }

  public EvaluatedDecisionInputItem inputValue(String inputValue) {
    this.inputValue = inputValue;
    return this;
  }

  /**
   * The value of the evaluated decision input.
   * @return inputValue
   */
  
  @Schema(name = "inputValue", description = "The value of the evaluated decision input.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("inputValue")
  public String getInputValue() {
    return inputValue;
  }

  public void setInputValue(String inputValue) {
    this.inputValue = inputValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluatedDecisionInputItem evaluatedDecisionInputItem = (EvaluatedDecisionInputItem) o;
    return Objects.equals(this.inputId, evaluatedDecisionInputItem.inputId) &&
        Objects.equals(this.inputName, evaluatedDecisionInputItem.inputName) &&
        Objects.equals(this.inputValue, evaluatedDecisionInputItem.inputValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(inputId, inputName, inputValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluatedDecisionInputItem {\n");
    sb.append("    inputId: ").append(toIndentedString(inputId)).append("\n");
    sb.append("    inputName: ").append(toIndentedString(inputName)).append("\n");
    sb.append("    inputValue: ").append(toIndentedString(inputValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

