package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.EvaluatedDecisionItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * EvaluateDecisionResponse
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluateDecisionResponse {

  private Long decisionDefinitionKey;

  private String decisionDefinitionId;

  private String decisionDefinitionName;

  private Integer decisionDefinitionVersion;

  private String decisionRequirementsId;

  private Long decisionRequirementsKey;

  private String output;

  private String failedDecisionDefinitionId;

  private String failureMessage;

  private String tenantId;

  private Long decisionInstanceKey;

  @Valid
  private List<@Valid EvaluatedDecisionItem> evaluatedDecisions = new ArrayList<>();

  public EvaluateDecisionResponse decisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the decision which was evaluated.
   * @return decisionDefinitionKey
   */
  
  @Schema(name = "decisionDefinitionKey", description = "The unique key identifying the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionKey")
  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public EvaluateDecisionResponse decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which was evaluated.
   * @return decisionDefinitionId
   */
  
  @Schema(name = "decisionDefinitionId", description = "The ID of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionId")
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public EvaluateDecisionResponse decisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the decision which was evaluated.
   * @return decisionDefinitionName
   */
  
  @Schema(name = "decisionDefinitionName", description = "The name of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionName")
  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }

  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public EvaluateDecisionResponse decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision which was evaluated.
   * @return decisionDefinitionVersion
   */
  
  @Schema(name = "decisionDefinitionVersion", description = "The version of the decision which was evaluated.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionVersion")
  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }

  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public EvaluateDecisionResponse decisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The ID of the decision requirements graph that the decision which was evaluated is part of.
   * @return decisionRequirementsId
   */
  
  @Schema(name = "decisionRequirementsId", description = "The ID of the decision requirements graph that the decision which was evaluated is part of.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsId")
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public EvaluateDecisionResponse decisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The unique key identifying the decision requirements graph that the decision which was evaluated is part of.
   * @return decisionRequirementsKey
   */
  
  @Schema(name = "decisionRequirementsKey", description = "The unique key identifying the decision requirements graph that the decision which was evaluated is part of.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsKey")
  public Long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public EvaluateDecisionResponse output(String output) {
    this.output = output;
    return this;
  }

  /**
   * JSON document that will instantiate the result of the decision which was evaluated. 
   * @return output
   */
  
  @Schema(name = "output", description = "JSON document that will instantiate the result of the decision which was evaluated. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("output")
  public String getOutput() {
    return output;
  }

  public void setOutput(String output) {
    this.output = output;
  }

  public EvaluateDecisionResponse failedDecisionDefinitionId(String failedDecisionDefinitionId) {
    this.failedDecisionDefinitionId = failedDecisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision which failed during evaluation.
   * @return failedDecisionDefinitionId
   */
  
  @Schema(name = "failedDecisionDefinitionId", description = "The ID of the decision which failed during evaluation.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("failedDecisionDefinitionId")
  public String getFailedDecisionDefinitionId() {
    return failedDecisionDefinitionId;
  }

  public void setFailedDecisionDefinitionId(String failedDecisionDefinitionId) {
    this.failedDecisionDefinitionId = failedDecisionDefinitionId;
  }

  public EvaluateDecisionResponse failureMessage(String failureMessage) {
    this.failureMessage = failureMessage;
    return this;
  }

  /**
   * Message describing why the decision which was evaluated failed.
   * @return failureMessage
   */
  
  @Schema(name = "failureMessage", description = "Message describing why the decision which was evaluated failed.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("failureMessage")
  public String getFailureMessage() {
    return failureMessage;
  }

  public void setFailureMessage(String failureMessage) {
    this.failureMessage = failureMessage;
  }

  public EvaluateDecisionResponse tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the evaluated decision.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the evaluated decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public EvaluateDecisionResponse decisionInstanceKey(Long decisionInstanceKey) {
    this.decisionInstanceKey = decisionInstanceKey;
    return this;
  }

  /**
   * The unique key identifying this decision evaluation.
   * @return decisionInstanceKey
   */
  
  @Schema(name = "decisionInstanceKey", description = "The unique key identifying this decision evaluation.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionInstanceKey")
  public Long getDecisionInstanceKey() {
    return decisionInstanceKey;
  }

  public void setDecisionInstanceKey(Long decisionInstanceKey) {
    this.decisionInstanceKey = decisionInstanceKey;
  }

  public EvaluateDecisionResponse evaluatedDecisions(List<@Valid EvaluatedDecisionItem> evaluatedDecisions) {
    this.evaluatedDecisions = evaluatedDecisions;
    return this;
  }

  public EvaluateDecisionResponse addEvaluatedDecisionsItem(EvaluatedDecisionItem evaluatedDecisionsItem) {
    if (this.evaluatedDecisions == null) {
      this.evaluatedDecisions = new ArrayList<>();
    }
    this.evaluatedDecisions.add(evaluatedDecisionsItem);
    return this;
  }

  /**
   * Get evaluatedDecisions
   * @return evaluatedDecisions
   */
  @Valid 
  @Schema(name = "evaluatedDecisions", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("evaluatedDecisions")
  public List<@Valid EvaluatedDecisionItem> getEvaluatedDecisions() {
    return evaluatedDecisions;
  }

  public void setEvaluatedDecisions(List<@Valid EvaluatedDecisionItem> evaluatedDecisions) {
    this.evaluatedDecisions = evaluatedDecisions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluateDecisionResponse evaluateDecisionResponse = (EvaluateDecisionResponse) o;
    return Objects.equals(this.decisionDefinitionKey, evaluateDecisionResponse.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionId, evaluateDecisionResponse.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, evaluateDecisionResponse.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, evaluateDecisionResponse.decisionDefinitionVersion) &&
        Objects.equals(this.decisionRequirementsId, evaluateDecisionResponse.decisionRequirementsId) &&
        Objects.equals(this.decisionRequirementsKey, evaluateDecisionResponse.decisionRequirementsKey) &&
        Objects.equals(this.output, evaluateDecisionResponse.output) &&
        Objects.equals(this.failedDecisionDefinitionId, evaluateDecisionResponse.failedDecisionDefinitionId) &&
        Objects.equals(this.failureMessage, evaluateDecisionResponse.failureMessage) &&
        Objects.equals(this.tenantId, evaluateDecisionResponse.tenantId) &&
        Objects.equals(this.decisionInstanceKey, evaluateDecisionResponse.decisionInstanceKey) &&
        Objects.equals(this.evaluatedDecisions, evaluateDecisionResponse.evaluatedDecisions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionKey, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionRequirementsId, decisionRequirementsKey, output, failedDecisionDefinitionId, failureMessage, tenantId, decisionInstanceKey, evaluatedDecisions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluateDecisionResponse {\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("    output: ").append(toIndentedString(output)).append("\n");
    sb.append("    failedDecisionDefinitionId: ").append(toIndentedString(failedDecisionDefinitionId)).append("\n");
    sb.append("    failureMessage: ").append(toIndentedString(failureMessage)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionInstanceKey: ").append(toIndentedString(decisionInstanceKey)).append("\n");
    sb.append("    evaluatedDecisions: ").append(toIndentedString(evaluatedDecisions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

