package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * EvaluateDecisionRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class EvaluateDecisionRequest {

  private Long decisionDefinitionKey;

  private String decisionDefinitionId;

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  private String tenantId;

  public EvaluateDecisionRequest decisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the decision to be evaluated. Cannot be used together with decisionDefinitionId. 
   * @return decisionDefinitionKey
   */
  
  @Schema(name = "decisionDefinitionKey", description = "The unique key identifying the decision to be evaluated. Cannot be used together with decisionDefinitionId. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionKey")
  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public EvaluateDecisionRequest decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the decision to be evaluated. Cannot be used together with decisionDefinitionKey. When using the decision ID, the latest deployed version of the decision is used. 
   * @return decisionDefinitionId
   */
  
  @Schema(name = "decisionDefinitionId", description = "The ID of the decision to be evaluated. Cannot be used together with decisionDefinitionKey. When using the decision ID, the latest deployed version of the decision is used. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionId")
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public EvaluateDecisionRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public EvaluateDecisionRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * The message variables as JSON document.
   * @return variables
   */
  
  @Schema(name = "variables", description = "The message variables as JSON document.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public EvaluateDecisionRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the decision.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EvaluateDecisionRequest evaluateDecisionRequest = (EvaluateDecisionRequest) o;
    return Objects.equals(this.decisionDefinitionKey, evaluateDecisionRequest.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionId, evaluateDecisionRequest.decisionDefinitionId) &&
        Objects.equals(this.variables, evaluateDecisionRequest.variables) &&
        Objects.equals(this.tenantId, evaluateDecisionRequest.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionKey, decisionDefinitionId, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EvaluateDecisionRequest {\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

