package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeploymentResponse
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentResponse {

  private Long deploymentKey;

  @Valid
  private List<@Valid DeploymentMetadata> deployments = new ArrayList<>();

  private String tenantId;

  public DeploymentResponse deploymentKey(Long deploymentKey) {
    this.deploymentKey = deploymentKey;
    return this;
  }

  /**
   * The unique key identifying the deployment.
   * @return deploymentKey
   */
  
  @Schema(name = "deploymentKey", description = "The unique key identifying the deployment.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("deploymentKey")
  public Long getDeploymentKey() {
    return deploymentKey;
  }

  public void setDeploymentKey(Long deploymentKey) {
    this.deploymentKey = deploymentKey;
  }

  public DeploymentResponse deployments(List<@Valid DeploymentMetadata> deployments) {
    this.deployments = deployments;
    return this;
  }

  public DeploymentResponse addDeploymentsItem(DeploymentMetadata deploymentsItem) {
    if (this.deployments == null) {
      this.deployments = new ArrayList<>();
    }
    this.deployments.add(deploymentsItem);
    return this;
  }

  /**
   * Get deployments
   * @return deployments
   */
  @Valid 
  @Schema(name = "deployments", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("deployments")
  public List<@Valid DeploymentMetadata> getDeployments() {
    return deployments;
  }

  public void setDeployments(List<@Valid DeploymentMetadata> deployments) {
    this.deployments = deployments;
  }

  public DeploymentResponse tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Get tenantId
   * @return tenantId
   */
  
  @Schema(name = "tenantId", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentResponse deploymentResponse = (DeploymentResponse) o;
    return Objects.equals(this.deploymentKey, deploymentResponse.deploymentKey) &&
        Objects.equals(this.deployments, deploymentResponse.deployments) &&
        Objects.equals(this.tenantId, deploymentResponse.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deploymentKey, deployments, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentResponse {\n");
    sb.append("    deploymentKey: ").append(toIndentedString(deploymentKey)).append("\n");
    sb.append("    deployments: ").append(toIndentedString(deployments)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

