package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeploymentProcess
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentProcess {

  private String processDefinitionId;

  private Integer processDefinitionVersion;

  private Long processDefinitionKey;

  private String resourceName;

  private String tenantId;

  public DeploymentProcess processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The bpmn process ID, as parsed during deployment, together with the version forms a unique identifier for a specific process definition. 
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", description = "The bpmn process ID, as parsed during deployment, together with the version forms a unique identifier for a specific process definition. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public DeploymentProcess processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The assigned process version.
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", description = "The assigned process version.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public DeploymentProcess processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this process.
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "The assigned key, which acts as a unique identifier for this process.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public DeploymentProcess resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The resource name from which this process was parsed.
   * @return resourceName
   */
  
  @Schema(name = "resourceName", description = "The resource name from which this process was parsed.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceName")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  public DeploymentProcess tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed process.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the deployed process.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentProcess deploymentProcess = (DeploymentProcess) o;
    return Objects.equals(this.processDefinitionId, deploymentProcess.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, deploymentProcess.processDefinitionVersion) &&
        Objects.equals(this.processDefinitionKey, deploymentProcess.processDefinitionKey) &&
        Objects.equals(this.resourceName, deploymentProcess.resourceName) &&
        Objects.equals(this.tenantId, deploymentProcess.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, processDefinitionVersion, processDefinitionKey, resourceName, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentProcess {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

