package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentDecision;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentDecisionRequirements;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentForm;
import io.camunda.zeebe.gateway.protocol.rest.DeploymentProcess;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeploymentMetadata
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentMetadata {

  private DeploymentProcess processDefinition;

  private DeploymentDecision decisionDefinition;

  private DeploymentDecisionRequirements decisionRequirements;

  private DeploymentForm form;

  public DeploymentMetadata processDefinition(DeploymentProcess processDefinition) {
    this.processDefinition = processDefinition;
    return this;
  }

  /**
   * Get processDefinition
   * @return processDefinition
   */
  @Valid 
  @Schema(name = "processDefinition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinition")
  public DeploymentProcess getProcessDefinition() {
    return processDefinition;
  }

  public void setProcessDefinition(DeploymentProcess processDefinition) {
    this.processDefinition = processDefinition;
  }

  public DeploymentMetadata decisionDefinition(DeploymentDecision decisionDefinition) {
    this.decisionDefinition = decisionDefinition;
    return this;
  }

  /**
   * Get decisionDefinition
   * @return decisionDefinition
   */
  @Valid 
  @Schema(name = "decisionDefinition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinition")
  public DeploymentDecision getDecisionDefinition() {
    return decisionDefinition;
  }

  public void setDecisionDefinition(DeploymentDecision decisionDefinition) {
    this.decisionDefinition = decisionDefinition;
  }

  public DeploymentMetadata decisionRequirements(DeploymentDecisionRequirements decisionRequirements) {
    this.decisionRequirements = decisionRequirements;
    return this;
  }

  /**
   * Get decisionRequirements
   * @return decisionRequirements
   */
  @Valid 
  @Schema(name = "decisionRequirements", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirements")
  public DeploymentDecisionRequirements getDecisionRequirements() {
    return decisionRequirements;
  }

  public void setDecisionRequirements(DeploymentDecisionRequirements decisionRequirements) {
    this.decisionRequirements = decisionRequirements;
  }

  public DeploymentMetadata form(DeploymentForm form) {
    this.form = form;
    return this;
  }

  /**
   * Get form
   * @return form
   */
  @Valid 
  @Schema(name = "form", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("form")
  public DeploymentForm getForm() {
    return form;
  }

  public void setForm(DeploymentForm form) {
    this.form = form;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentMetadata deploymentMetadata = (DeploymentMetadata) o;
    return Objects.equals(this.processDefinition, deploymentMetadata.processDefinition) &&
        Objects.equals(this.decisionDefinition, deploymentMetadata.decisionDefinition) &&
        Objects.equals(this.decisionRequirements, deploymentMetadata.decisionRequirements) &&
        Objects.equals(this.form, deploymentMetadata.form);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinition, decisionDefinition, decisionRequirements, form);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentMetadata {\n");
    sb.append("    processDefinition: ").append(toIndentedString(processDefinition)).append("\n");
    sb.append("    decisionDefinition: ").append(toIndentedString(decisionDefinition)).append("\n");
    sb.append("    decisionRequirements: ").append(toIndentedString(decisionRequirements)).append("\n");
    sb.append("    form: ").append(toIndentedString(form)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

