package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeploymentForm
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentForm {

  private String formId;

  private Integer version;

  private Long formKey;

  private String resourceName;

  private String tenantId;

  public DeploymentForm formId(String formId) {
    this.formId = formId;
    return this;
  }

  /**
   * The form ID, as parsed during deployment, together with the version forms a unique identifier for a specific form. 
   * @return formId
   */
  
  @Schema(name = "formId", description = "The form ID, as parsed during deployment, together with the version forms a unique identifier for a specific form. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("formId")
  public String getFormId() {
    return formId;
  }

  public void setFormId(String formId) {
    this.formId = formId;
  }

  public DeploymentForm version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * The assigned form version.
   * @return version
   */
  
  @Schema(name = "version", description = "The assigned form version.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public DeploymentForm formKey(Long formKey) {
    this.formKey = formKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this form.
   * @return formKey
   */
  
  @Schema(name = "formKey", description = "The assigned key, which acts as a unique identifier for this form.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("formKey")
  public Long getFormKey() {
    return formKey;
  }

  public void setFormKey(Long formKey) {
    this.formKey = formKey;
  }

  public DeploymentForm resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The resource name from which this form was parsed.
   * @return resourceName
   */
  
  @Schema(name = "resourceName", description = "The resource name from which this form was parsed.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceName")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  public DeploymentForm tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed form.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the deployed form.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentForm deploymentForm = (DeploymentForm) o;
    return Objects.equals(this.formId, deploymentForm.formId) &&
        Objects.equals(this.version, deploymentForm.version) &&
        Objects.equals(this.formKey, deploymentForm.formKey) &&
        Objects.equals(this.resourceName, deploymentForm.resourceName) &&
        Objects.equals(this.tenantId, deploymentForm.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(formId, version, formKey, resourceName, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentForm {\n");
    sb.append("    formId: ").append(toIndentedString(formId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    formKey: ").append(toIndentedString(formKey)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

