package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeploymentDecisionRequirements
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentDecisionRequirements {

  private String decisionRequirementsId;

  private Integer version;

  private String decisionRequirementsName;

  private String tenantId;

  private Long decisionRequirementsKey;

  private String resourceName;

  public DeploymentDecisionRequirements decisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The dmn decision requirements ID, as parsed during deployment; together with the versions forms a unique identifier for a specific decision. 
   * @return decisionRequirementsId
   */
  
  @Schema(name = "decisionRequirementsId", description = "The dmn decision requirements ID, as parsed during deployment; together with the versions forms a unique identifier for a specific decision. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsId")
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DeploymentDecisionRequirements version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * The assigned decision requirements version.
   * @return version
   */
  
  @Schema(name = "version", description = "The assigned decision requirements version.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public DeploymentDecisionRequirements decisionRequirementsName(String decisionRequirementsName) {
    this.decisionRequirementsName = decisionRequirementsName;
    return this;
  }

  /**
   * The DMN name of the decision requirements, as parsed during deployment.
   * @return decisionRequirementsName
   */
  
  @Schema(name = "decisionRequirementsName", description = "The DMN name of the decision requirements, as parsed during deployment.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsName")
  public String getDecisionRequirementsName() {
    return decisionRequirementsName;
  }

  public void setDecisionRequirementsName(String decisionRequirementsName) {
    this.decisionRequirementsName = decisionRequirementsName;
  }

  public DeploymentDecisionRequirements tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed decision requirements.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the deployed decision requirements.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public DeploymentDecisionRequirements decisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned decision requirements key, which acts as a unique identifier for this decision requirements. 
   * @return decisionRequirementsKey
   */
  
  @Schema(name = "decisionRequirementsKey", description = "The assigned decision requirements key, which acts as a unique identifier for this decision requirements. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsKey")
  public Long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public DeploymentDecisionRequirements resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The resource name from which this decision requirements was parsed.
   * @return resourceName
   */
  
  @Schema(name = "resourceName", description = "The resource name from which this decision requirements was parsed.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceName")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentDecisionRequirements deploymentDecisionRequirements = (DeploymentDecisionRequirements) o;
    return Objects.equals(this.decisionRequirementsId, deploymentDecisionRequirements.decisionRequirementsId) &&
        Objects.equals(this.version, deploymentDecisionRequirements.version) &&
        Objects.equals(this.decisionRequirementsName, deploymentDecisionRequirements.decisionRequirementsName) &&
        Objects.equals(this.tenantId, deploymentDecisionRequirements.tenantId) &&
        Objects.equals(this.decisionRequirementsKey, deploymentDecisionRequirements.decisionRequirementsKey) &&
        Objects.equals(this.resourceName, deploymentDecisionRequirements.resourceName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionRequirementsId, version, decisionRequirementsName, tenantId, decisionRequirementsKey, resourceName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentDecisionRequirements {\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    decisionRequirementsName: ").append(toIndentedString(decisionRequirementsName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

