package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeploymentDecision
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeploymentDecision {

  private String decisionDefinitionId;

  private Integer version;

  private Long decisionDefinitionKey;

  private String name;

  private String tenantId;

  private String decisionRequirementsId;

  private Long decisionRequirementsKey;

  public DeploymentDecision decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The dmn decision ID, as parsed during deployment, together with the version forms a unique identifier for a specific decision. 
   * @return decisionDefinitionId
   */
  
  @Schema(name = "decisionDefinitionId", description = "The dmn decision ID, as parsed during deployment, together with the version forms a unique identifier for a specific decision. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionId")
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DeploymentDecision version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * The assigned decision version.
   * @return version
   */
  
  @Schema(name = "version", description = "The assigned decision version.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public DeploymentDecision decisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The assigned decision key, which acts as a unique identifier for this decision. 
   * @return decisionDefinitionKey
   */
  
  @Schema(name = "decisionDefinitionKey", description = "The assigned decision key, which acts as a unique identifier for this decision. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionKey")
  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DeploymentDecision name(String name) {
    this.name = name;
    return this;
  }

  /**
   * The DMN name of the decision, as parsed during deployment.
   * @return name
   */
  
  @Schema(name = "name", description = "The DMN name of the decision, as parsed during deployment.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DeploymentDecision tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the deployed decision.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the deployed decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public DeploymentDecision decisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * The dmn ID of the decision requirements graph that this decision is part of, as parsed during deployment. 
   * @return decisionRequirementsId
   */
  
  @Schema(name = "decisionRequirementsId", description = "The dmn ID of the decision requirements graph that this decision is part of, as parsed during deployment. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsId")
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DeploymentDecision decisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned key of the decision requirements graph that this decision is part of. 
   * @return decisionRequirementsKey
   */
  
  @Schema(name = "decisionRequirementsKey", description = "The assigned key of the decision requirements graph that this decision is part of. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsKey")
  public Long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentDecision deploymentDecision = (DeploymentDecision) o;
    return Objects.equals(this.decisionDefinitionId, deploymentDecision.decisionDefinitionId) &&
        Objects.equals(this.version, deploymentDecision.version) &&
        Objects.equals(this.decisionDefinitionKey, deploymentDecision.decisionDefinitionKey) &&
        Objects.equals(this.name, deploymentDecision.name) &&
        Objects.equals(this.tenantId, deploymentDecision.tenantId) &&
        Objects.equals(this.decisionRequirementsId, deploymentDecision.decisionRequirementsId) &&
        Objects.equals(this.decisionRequirementsKey, deploymentDecision.decisionRequirementsKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionId, version, decisionDefinitionKey, name, tenantId, decisionRequirementsId, decisionRequirementsKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentDecision {\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

