package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DeleteResourceRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DeleteResourceRequest {

  private Long operationReference;

  public DeleteResourceRequest operationReference(Long operationReference) {
    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. 
   * minimum: 1
   * @return operationReference
   */
  @Min(1L) 
  @Schema(name = "operationReference", description = "A reference key chosen by the user that will be part of all records resulting from this operation. Must be > 0 if provided. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationReference")
  public Long getOperationReference() {
    return operationReference;
  }

  public void setOperationReference(Long operationReference) {
    this.operationReference = operationReference;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeleteResourceRequest deleteResourceRequest = (DeleteResourceRequest) o;
    return Objects.equals(this.operationReference, deleteResourceRequest.operationReference);
  }

  @Override
  public int hashCode() {
    return Objects.hash(operationReference);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeleteResourceRequest {\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

