package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DecisionRequirementsItem
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DecisionRequirementsItem {

  private Long decisionRequirementsKey;

  private String decisionRequirementsName;

  private Integer version;

  private String decisionRequirementsId;

  private String resourceName;

  private String tenantId;

  public DecisionRequirementsItem decisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this decision requirements.
   * @return decisionRequirementsKey
   */
  
  @Schema(name = "decisionRequirementsKey", description = "The assigned key, which acts as a unique identifier for this decision requirements.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsKey")
  public Long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public DecisionRequirementsItem decisionRequirementsName(String decisionRequirementsName) {
    this.decisionRequirementsName = decisionRequirementsName;
    return this;
  }

  /**
   * The DMN name of the decision requirements.
   * @return decisionRequirementsName
   */
  
  @Schema(name = "decisionRequirementsName", description = "The DMN name of the decision requirements.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsName")
  public String getDecisionRequirementsName() {
    return decisionRequirementsName;
  }

  public void setDecisionRequirementsName(String decisionRequirementsName) {
    this.decisionRequirementsName = decisionRequirementsName;
  }

  public DecisionRequirementsItem version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * The assigned version of the decision requirements.
   * @return version
   */
  
  @Schema(name = "version", description = "The assigned version of the decision requirements.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public DecisionRequirementsItem decisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * the DMN id of the decision requirements.
   * @return decisionRequirementsId
   */
  
  @Schema(name = "decisionRequirementsId", description = "the DMN id of the decision requirements.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsId")
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DecisionRequirementsItem resourceName(String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The name of the resource from which this decision requirements was parsed.
   * @return resourceName
   */
  
  @Schema(name = "resourceName", description = "The name of the resource from which this decision requirements was parsed.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceName")
  public String getResourceName() {
    return resourceName;
  }

  public void setResourceName(String resourceName) {
    this.resourceName = resourceName;
  }

  public DecisionRequirementsItem tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the decision requirements.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the decision requirements.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionRequirementsItem decisionRequirementsItem = (DecisionRequirementsItem) o;
    return Objects.equals(this.decisionRequirementsKey, decisionRequirementsItem.decisionRequirementsKey) &&
        Objects.equals(this.decisionRequirementsName, decisionRequirementsItem.decisionRequirementsName) &&
        Objects.equals(this.version, decisionRequirementsItem.version) &&
        Objects.equals(this.decisionRequirementsId, decisionRequirementsItem.decisionRequirementsId) &&
        Objects.equals(this.resourceName, decisionRequirementsItem.resourceName) &&
        Objects.equals(this.tenantId, decisionRequirementsItem.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionRequirementsKey, decisionRequirementsName, version, decisionRequirementsId, resourceName, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionRequirementsItem {\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("    decisionRequirementsName: ").append(toIndentedString(decisionRequirementsName)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

