package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceStateEnum;
import io.camunda.zeebe.gateway.protocol.rest.DecisionInstanceTypeEnum;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DecisionInstanceItem
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DecisionInstanceItem {

  private Long key;

  private DecisionInstanceStateEnum state;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String evaluationDate;

  private String evaluationFailure;

  private Long processDefinitionKey;

  private Long processInstanceKey;

  private Long decisionDefinitionKey;

  private String decisionDefinitionId;

  private String decisionDefinitionName;

  private Integer decisionDefinitionVersion;

  private DecisionInstanceTypeEnum decisionDefinitionType;

  private String result;

  private String tenantId;

  public DecisionInstanceItem key(Long key) {
    this.key = key;
    return this;
  }

  /**
   * The key of the decision instance.
   * @return key
   */
  
  @Schema(name = "key", description = "The key of the decision instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("key")
  public Long getKey() {
    return key;
  }

  public void setKey(Long key) {
    this.key = key;
  }

  public DecisionInstanceItem state(DecisionInstanceStateEnum state) {
    this.state = state;
    return this;
  }

  /**
   * Get state
   * @return state
   */
  @Valid 
  @Schema(name = "state", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state")
  public DecisionInstanceStateEnum getState() {
    return state;
  }

  public void setState(DecisionInstanceStateEnum state) {
    this.state = state;
  }

  public DecisionInstanceItem evaluationDate(String evaluationDate) {
    this.evaluationDate = evaluationDate;
    return this;
  }

  /**
   * The evaluation date of the decision instance.
   * @return evaluationDate
   */
  @Valid 
  @Schema(name = "evaluationDate", description = "The evaluation date of the decision instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("evaluationDate")
  public String getEvaluationDate() {
    return evaluationDate;
  }

  public void setEvaluationDate(String evaluationDate) {
    this.evaluationDate = evaluationDate;
  }

  public DecisionInstanceItem evaluationFailure(String evaluationFailure) {
    this.evaluationFailure = evaluationFailure;
    return this;
  }

  /**
   * The evaluation failure of the decision instance.
   * @return evaluationFailure
   */
  
  @Schema(name = "evaluationFailure", description = "The evaluation failure of the decision instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("evaluationFailure")
  public String getEvaluationFailure() {
    return evaluationFailure;
  }

  public void setEvaluationFailure(String evaluationFailure) {
    this.evaluationFailure = evaluationFailure;
  }

  public DecisionInstanceItem processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition.
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "The key of the process definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public DecisionInstanceItem processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of the process instance.
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", description = "The key of the process instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public DecisionInstanceItem decisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The key of the decision.
   * @return decisionDefinitionKey
   */
  
  @Schema(name = "decisionDefinitionKey", description = "The key of the decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionKey")
  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DecisionInstanceItem decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The ID of the DMN decision.
   * @return decisionDefinitionId
   */
  
  @Schema(name = "decisionDefinitionId", description = "The ID of the DMN decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionId")
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DecisionInstanceItem decisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The name of the DMN decision.
   * @return decisionDefinitionName
   */
  
  @Schema(name = "decisionDefinitionName", description = "The name of the DMN decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionName")
  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }

  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public DecisionInstanceItem decisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
    return this;
  }

  /**
   * The version of the decision.
   * @return decisionDefinitionVersion
   */
  
  @Schema(name = "decisionDefinitionVersion", description = "The version of the decision.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionVersion")
  public Integer getDecisionDefinitionVersion() {
    return decisionDefinitionVersion;
  }

  public void setDecisionDefinitionVersion(Integer decisionDefinitionVersion) {
    this.decisionDefinitionVersion = decisionDefinitionVersion;
  }

  public DecisionInstanceItem decisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
    return this;
  }

  /**
   * Get decisionDefinitionType
   * @return decisionDefinitionType
   */
  @Valid 
  @Schema(name = "decisionDefinitionType", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionType")
  public DecisionInstanceTypeEnum getDecisionDefinitionType() {
    return decisionDefinitionType;
  }

  public void setDecisionDefinitionType(DecisionInstanceTypeEnum decisionDefinitionType) {
    this.decisionDefinitionType = decisionDefinitionType;
  }

  public DecisionInstanceItem result(String result) {
    this.result = result;
    return this;
  }

  /**
   * The result of the decision instance.
   * @return result
   */
  
  @Schema(name = "result", description = "The result of the decision instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("result")
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public DecisionInstanceItem tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the decision instance.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the decision instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionInstanceItem decisionInstanceItem = (DecisionInstanceItem) o;
    return Objects.equals(this.key, decisionInstanceItem.key) &&
        Objects.equals(this.state, decisionInstanceItem.state) &&
        Objects.equals(this.evaluationDate, decisionInstanceItem.evaluationDate) &&
        Objects.equals(this.evaluationFailure, decisionInstanceItem.evaluationFailure) &&
        Objects.equals(this.processDefinitionKey, decisionInstanceItem.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, decisionInstanceItem.processInstanceKey) &&
        Objects.equals(this.decisionDefinitionKey, decisionInstanceItem.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionId, decisionInstanceItem.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, decisionInstanceItem.decisionDefinitionName) &&
        Objects.equals(this.decisionDefinitionVersion, decisionInstanceItem.decisionDefinitionVersion) &&
        Objects.equals(this.decisionDefinitionType, decisionInstanceItem.decisionDefinitionType) &&
        Objects.equals(this.result, decisionInstanceItem.result) &&
        Objects.equals(this.tenantId, decisionInstanceItem.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, state, evaluationDate, evaluationFailure, processDefinitionKey, processInstanceKey, decisionDefinitionKey, decisionDefinitionId, decisionDefinitionName, decisionDefinitionVersion, decisionDefinitionType, result, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionInstanceItem {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    evaluationDate: ").append(toIndentedString(evaluationDate)).append("\n");
    sb.append("    evaluationFailure: ").append(toIndentedString(evaluationFailure)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    decisionDefinitionVersion: ").append(toIndentedString(decisionDefinitionVersion)).append("\n");
    sb.append("    decisionDefinitionType: ").append(toIndentedString(decisionDefinitionType)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

