package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DecisionDefinitionItem
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class DecisionDefinitionItem {

  private Long decisionDefinitionKey;

  private String decisionDefinitionId;

  private String decisionDefinitionName;

  private Integer version;

  private String decisionRequirementsId;

  private Long decisionRequirementsKey;

  private String tenantId;

  public DecisionDefinitionItem decisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this decision definition.
   * @return decisionDefinitionKey
   */
  
  @Schema(name = "decisionDefinitionKey", description = "The assigned key, which acts as a unique identifier for this decision definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionKey")
  public Long getDecisionDefinitionKey() {
    return decisionDefinitionKey;
  }

  public void setDecisionDefinitionKey(Long decisionDefinitionKey) {
    this.decisionDefinitionKey = decisionDefinitionKey;
  }

  public DecisionDefinitionItem decisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
    return this;
  }

  /**
   * The DMN id of the decision definition.
   * @return decisionDefinitionId
   */
  
  @Schema(name = "decisionDefinitionId", description = "The DMN id of the decision definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionId")
  public String getDecisionDefinitionId() {
    return decisionDefinitionId;
  }

  public void setDecisionDefinitionId(String decisionDefinitionId) {
    this.decisionDefinitionId = decisionDefinitionId;
  }

  public DecisionDefinitionItem decisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
    return this;
  }

  /**
   * The DMN name of the decision definition.
   * @return decisionDefinitionName
   */
  
  @Schema(name = "decisionDefinitionName", description = "The DMN name of the decision definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionDefinitionName")
  public String getDecisionDefinitionName() {
    return decisionDefinitionName;
  }

  public void setDecisionDefinitionName(String decisionDefinitionName) {
    this.decisionDefinitionName = decisionDefinitionName;
  }

  public DecisionDefinitionItem version(Integer version) {
    this.version = version;
    return this;
  }

  /**
   * The assigned version of the decision definition.
   * @return version
   */
  
  @Schema(name = "version", description = "The assigned version of the decision definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public DecisionDefinitionItem decisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
    return this;
  }

  /**
   * the DMN id of the decision requirements graph that the decision definition is part of.
   * @return decisionRequirementsId
   */
  
  @Schema(name = "decisionRequirementsId", description = "the DMN id of the decision requirements graph that the decision definition is part of.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsId")
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  public void setDecisionRequirementsId(String decisionRequirementsId) {
    this.decisionRequirementsId = decisionRequirementsId;
  }

  public DecisionDefinitionItem decisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
    return this;
  }

  /**
   * The assigned key of the decision requirements graph that the decision definition is part of.
   * @return decisionRequirementsKey
   */
  
  @Schema(name = "decisionRequirementsKey", description = "The assigned key of the decision requirements graph that the decision definition is part of.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("decisionRequirementsKey")
  public Long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  public void setDecisionRequirementsKey(Long decisionRequirementsKey) {
    this.decisionRequirementsKey = decisionRequirementsKey;
  }

  public DecisionDefinitionItem tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant id of the decision definition.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant id of the decision definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionDefinitionItem decisionDefinitionItem = (DecisionDefinitionItem) o;
    return Objects.equals(this.decisionDefinitionKey, decisionDefinitionItem.decisionDefinitionKey) &&
        Objects.equals(this.decisionDefinitionId, decisionDefinitionItem.decisionDefinitionId) &&
        Objects.equals(this.decisionDefinitionName, decisionDefinitionItem.decisionDefinitionName) &&
        Objects.equals(this.version, decisionDefinitionItem.version) &&
        Objects.equals(this.decisionRequirementsId, decisionDefinitionItem.decisionRequirementsId) &&
        Objects.equals(this.decisionRequirementsKey, decisionDefinitionItem.decisionRequirementsKey) &&
        Objects.equals(this.tenantId, decisionDefinitionItem.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decisionDefinitionKey, decisionDefinitionId, decisionDefinitionName, version, decisionRequirementsId, decisionRequirementsKey, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionDefinitionItem {\n");
    sb.append("    decisionDefinitionKey: ").append(toIndentedString(decisionDefinitionKey)).append("\n");
    sb.append("    decisionDefinitionId: ").append(toIndentedString(decisionDefinitionId)).append("\n");
    sb.append("    decisionDefinitionName: ").append(toIndentedString(decisionDefinitionName)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    decisionRequirementsId: ").append(toIndentedString(decisionRequirementsId)).append("\n");
    sb.append("    decisionRequirementsKey: ").append(toIndentedString(decisionRequirementsKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

