package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * CreateProcessInstanceResponse
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class CreateProcessInstanceResponse {

  private Long processDefinitionKey;

  private String processDefinitionId;

  private Integer processDefinitionVersion;

  private Long processInstanceKey;

  private String tenantId;

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  public CreateProcessInstanceResponse processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition which was used to create the process instance. 
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "The key of the process definition which was used to create the process instance. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public CreateProcessInstanceResponse processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The BPMN process ID of the process definition which was used to create the process. instance 
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", description = "The BPMN process ID of the process definition which was used to create the process. instance ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public CreateProcessInstanceResponse processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the process definition which was used to create the process instance. 
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", description = "The version of the process definition which was used to create the process instance. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public CreateProcessInstanceResponse processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The unique identifier of the created process instance; to be used wherever a request needs a process instance key (e.g. CancelProcessInstanceRequest). 
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", description = "The unique identifier of the created process instance; to be used wherever a request needs a process instance key (e.g. CancelProcessInstanceRequest). ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public CreateProcessInstanceResponse tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the created process instance.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the created process instance.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public CreateProcessInstanceResponse variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public CreateProcessInstanceResponse putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All the variables visible in the root scope.
   * @return variables
   */
  
  @Schema(name = "variables", description = "All the variables visible in the root scope.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateProcessInstanceResponse createProcessInstanceResponse = (CreateProcessInstanceResponse) o;
    return Objects.equals(this.processDefinitionKey, createProcessInstanceResponse.processDefinitionKey) &&
        Objects.equals(this.processDefinitionId, createProcessInstanceResponse.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, createProcessInstanceResponse.processDefinitionVersion) &&
        Objects.equals(this.processInstanceKey, createProcessInstanceResponse.processInstanceKey) &&
        Objects.equals(this.tenantId, createProcessInstanceResponse.tenantId) &&
        Objects.equals(this.variables, createProcessInstanceResponse.variables);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionKey, processDefinitionId, processDefinitionVersion, processInstanceKey, tenantId, variables);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateProcessInstanceResponse {\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

