package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.ProcessInstanceCreationStartInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * CreateProcessInstanceRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class CreateProcessInstanceRequest {

  private Long processDefinitionKey;

  private String processDefinitionId;

  private Integer processDefinitionVersion = -1;

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  private String tenantId;

  private Long operationReference;

  @Valid
  private List<@Valid ProcessInstanceCreationStartInstruction> startInstructions = new ArrayList<>();

  private Boolean awaitCompletion = false;

  @Valid
  private List<String> fetchVariables = new ArrayList<>();

  private Long requestTimeout;

  public CreateProcessInstanceRequest processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the process definition, e.g. returned for a process in the deploy resources endpoint. Cannot be used together with processDefinitionId. 
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "The unique key identifying the process definition, e.g. returned for a process in the deploy resources endpoint. Cannot be used together with processDefinitionId. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public CreateProcessInstanceRequest processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The BPMN process ID of the process definition to start an instance of. Cannot be used together with processDefinitionKey. 
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", description = "The BPMN process ID of the process definition to start an instance of. Cannot be used together with processDefinitionKey. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public CreateProcessInstanceRequest processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the process. Only considered when a processDefinitionId is provided. By default, the latest version of the process is used. 
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", description = "The version of the process. Only considered when a processDefinitionId is provided. By default, the latest version of the process is used. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public CreateProcessInstanceRequest variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public CreateProcessInstanceRequest putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON object that will instantiate the variables for the root variable scope of the process instance. 
   * @return variables
   */
  
  @Schema(name = "variables", description = "JSON object that will instantiate the variables for the root variable scope of the process instance. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public CreateProcessInstanceRequest tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the process definition.
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The tenant ID of the process definition.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  public CreateProcessInstanceRequest operationReference(Long operationReference) {
    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this operation. Must be >0 if provided. 
   * minimum: 1
   * @return operationReference
   */
  @Min(1L) 
  @Schema(name = "operationReference", description = "A reference key chosen by the user that will be part of all records resulting from this operation. Must be >0 if provided. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("operationReference")
  public Long getOperationReference() {
    return operationReference;
  }

  public void setOperationReference(Long operationReference) {
    this.operationReference = operationReference;
  }

  public CreateProcessInstanceRequest startInstructions(List<@Valid ProcessInstanceCreationStartInstruction> startInstructions) {
    this.startInstructions = startInstructions;
    return this;
  }

  public CreateProcessInstanceRequest addStartInstructionsItem(ProcessInstanceCreationStartInstruction startInstructionsItem) {
    if (this.startInstructions == null) {
      this.startInstructions = new ArrayList<>();
    }
    this.startInstructions.add(startInstructionsItem);
    return this;
  }

  /**
   * List of start instructions. By default, the process instance will start at the start event. If provided, the process instance will apply start instructions after it has been created. 
   * @return startInstructions
   */
  @Valid 
  @Schema(name = "startInstructions", description = "List of start instructions. By default, the process instance will start at the start event. If provided, the process instance will apply start instructions after it has been created. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startInstructions")
  public List<@Valid ProcessInstanceCreationStartInstruction> getStartInstructions() {
    return startInstructions;
  }

  public void setStartInstructions(List<@Valid ProcessInstanceCreationStartInstruction> startInstructions) {
    this.startInstructions = startInstructions;
  }

  public CreateProcessInstanceRequest awaitCompletion(Boolean awaitCompletion) {
    this.awaitCompletion = awaitCompletion;
    return this;
  }

  /**
   * Wait for the process instance to complete. If the process instance completion does not occur within the requestTimeout, the request will be closed. Disabled by default. 
   * @return awaitCompletion
   */
  
  @Schema(name = "awaitCompletion", description = "Wait for the process instance to complete. If the process instance completion does not occur within the requestTimeout, the request will be closed. Disabled by default. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("awaitCompletion")
  public Boolean getAwaitCompletion() {
    return awaitCompletion;
  }

  public void setAwaitCompletion(Boolean awaitCompletion) {
    this.awaitCompletion = awaitCompletion;
  }

  public CreateProcessInstanceRequest fetchVariables(List<String> fetchVariables) {
    this.fetchVariables = fetchVariables;
    return this;
  }

  public CreateProcessInstanceRequest addFetchVariablesItem(String fetchVariablesItem) {
    if (this.fetchVariables == null) {
      this.fetchVariables = new ArrayList<>();
    }
    this.fetchVariables.add(fetchVariablesItem);
    return this;
  }

  /**
   * List of variables names to be included in the response. If empty, all visible variables in the root scope will be returned. 
   * @return fetchVariables
   */
  
  @Schema(name = "fetchVariables", description = "List of variables names to be included in the response. If empty, all visible variables in the root scope will be returned. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fetchVariables")
  public List<String> getFetchVariables() {
    return fetchVariables;
  }

  public void setFetchVariables(List<String> fetchVariables) {
    this.fetchVariables = fetchVariables;
  }

  public CreateProcessInstanceRequest requestTimeout(Long requestTimeout) {
    this.requestTimeout = requestTimeout;
    return this;
  }

  /**
   * Timeout (in ms) the request waits for the process to complete. By default or when set to 0, the generic request timeout configured in the cluster is applied. 
   * @return requestTimeout
   */
  
  @Schema(name = "requestTimeout", description = "Timeout (in ms) the request waits for the process to complete. By default or when set to 0, the generic request timeout configured in the cluster is applied. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("requestTimeout")
  public Long getRequestTimeout() {
    return requestTimeout;
  }

  public void setRequestTimeout(Long requestTimeout) {
    this.requestTimeout = requestTimeout;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateProcessInstanceRequest createProcessInstanceRequest = (CreateProcessInstanceRequest) o;
    return Objects.equals(this.processDefinitionKey, createProcessInstanceRequest.processDefinitionKey) &&
        Objects.equals(this.processDefinitionId, createProcessInstanceRequest.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, createProcessInstanceRequest.processDefinitionVersion) &&
        Objects.equals(this.variables, createProcessInstanceRequest.variables) &&
        Objects.equals(this.tenantId, createProcessInstanceRequest.tenantId) &&
        Objects.equals(this.operationReference, createProcessInstanceRequest.operationReference) &&
        Objects.equals(this.startInstructions, createProcessInstanceRequest.startInstructions) &&
        Objects.equals(this.awaitCompletion, createProcessInstanceRequest.awaitCompletion) &&
        Objects.equals(this.fetchVariables, createProcessInstanceRequest.fetchVariables) &&
        Objects.equals(this.requestTimeout, createProcessInstanceRequest.requestTimeout);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionKey, processDefinitionId, processDefinitionVersion, variables, tenantId, operationReference, startInstructions, awaitCompletion, fetchVariables, requestTimeout);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateProcessInstanceRequest {\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("    startInstructions: ").append(toIndentedString(startInstructions)).append("\n");
    sb.append("    awaitCompletion: ").append(toIndentedString(awaitCompletion)).append("\n");
    sb.append("    fetchVariables: ").append(toIndentedString(fetchVariables)).append("\n");
    sb.append("    requestTimeout: ").append(toIndentedString(requestTimeout)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

