package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
/**
 * JSON object with changed task attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * &#x60;candidateGroups&#x60; - reset by providing an empty list * &#x60;candidateUsers&#x60; - reset by providing an empty list * &#x60;dueDate&#x60; - reset by providing an empty String * &#x60;followUpDate&#x60; - reset by providing an empty String * &#x60;priority&#x60; - minimum 0, maximum 100, default 50  Providing any of those attributes with a &#x60;null&#x60; value or omitting it preserves the persisted attribute&#39;s value.  The assignee cannot be adjusted with this endpoint, use the Assign task endpoint. This ensures correct event emission for assignee changes. 
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "Changeset", description = "JSON object with changed task attribute values.  The following attributes can be adjusted with this endpoint, additional attributes will be ignored:  * `candidateGroups` - reset by providing an empty list * `candidateUsers` - reset by providing an empty list * `dueDate` - reset by providing an empty String * `followUpDate` - reset by providing an empty String * `priority` - minimum 0, maximum 100, default 50  Providing any of those attributes with a `null` value or omitting it preserves the persisted attribute's value.  The assignee cannot be adjusted with this endpoint, use the Assign task endpoint. This ensures correct event emission for assignee changes. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class Changeset {

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String dueDate = null;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private String followUpDate = null;

  @Valid
  private List<String> candidateUsers;

  @Valid
  private List<String> candidateGroups;

  private Integer priority = null;

  public Changeset dueDate(String dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * The due date of the task. Reset by providing an empty String.
   * @return dueDate
   */
  @Valid 
  @Schema(name = "dueDate", description = "The due date of the task. Reset by providing an empty String.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dueDate")
  public String getDueDate() {
    return dueDate;
  }

  public void setDueDate(String dueDate) {
    this.dueDate = dueDate;
  }

  public Changeset followUpDate(String followUpDate) {
    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * The follow-up date of the task. Reset by providing an empty String.
   * @return followUpDate
   */
  @Valid 
  @Schema(name = "followUpDate", description = "The follow-up date of the task. Reset by providing an empty String.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("followUpDate")
  public String getFollowUpDate() {
    return followUpDate;
  }

  public void setFollowUpDate(String followUpDate) {
    this.followUpDate = followUpDate;
  }

  public Changeset candidateUsers(List<String> candidateUsers) {
    this.candidateUsers = candidateUsers;
    return this;
  }

  public Changeset addCandidateUsersItem(String candidateUsersItem) {
    if (this.candidateUsers == null) {
      this.candidateUsers = new ArrayList<>();
    }
    this.candidateUsers.add(candidateUsersItem);
    return this;
  }

  /**
   * The list of candidate users of the task. Reset by providing an empty list.
   * @return candidateUsers
   */
  
  @Schema(name = "candidateUsers", description = "The list of candidate users of the task. Reset by providing an empty list.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("candidateUsers")
  public List<String> getCandidateUsers() {
    return candidateUsers;
  }

  public void setCandidateUsers(List<String> candidateUsers) {
    this.candidateUsers = candidateUsers;
  }

  public Changeset candidateGroups(List<String> candidateGroups) {
    this.candidateGroups = candidateGroups;
    return this;
  }

  public Changeset addCandidateGroupsItem(String candidateGroupsItem) {
    if (this.candidateGroups == null) {
      this.candidateGroups = new ArrayList<>();
    }
    this.candidateGroups.add(candidateGroupsItem);
    return this;
  }

  /**
   * The list of candidate groups of the task. Reset by providing an empty list.
   * @return candidateGroups
   */
  
  @Schema(name = "candidateGroups", description = "The list of candidate groups of the task. Reset by providing an empty list.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("candidateGroups")
  public List<String> getCandidateGroups() {
    return candidateGroups;
  }

  public void setCandidateGroups(List<String> candidateGroups) {
    this.candidateGroups = candidateGroups;
  }

  public Changeset priority(Integer priority) {
    this.priority = priority;
    return this;
  }

  /**
   * The priority of the task.
   * minimum: 0
   * maximum: 100
   * @return priority
   */
  @Min(0) @Max(100) 
  @Schema(name = "priority", description = "The priority of the task.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("priority")
  public Integer getPriority() {
    return priority;
  }

  public void setPriority(Integer priority) {
    this.priority = priority;
  }
    /**
    * A container for additional, undeclared properties.
    * This is a holder for any undeclared properties as specified with
    * the 'additionalProperties' keyword in the OAS document.
    */
    private Map<String, Object> additionalProperties;

    /**
    * Set the additional (undeclared) property with the specified name and value.
    * If the property does not already exist, create it otherwise replace it.
    */
    @JsonAnySetter
    public Changeset putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    /**
    * Return the additional (undeclared) property.
    */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    /**
    * Return the additional (undeclared) property with the specified name.
    */
    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Changeset changeset = (Changeset) o;
    return Objects.equals(this.dueDate, changeset.dueDate) &&
        Objects.equals(this.followUpDate, changeset.followUpDate) &&
        Objects.equals(this.candidateUsers, changeset.candidateUsers) &&
        Objects.equals(this.candidateGroups, changeset.candidateGroups) &&
        Objects.equals(this.priority, changeset.priority) &&
    Objects.equals(this.additionalProperties, changeset.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dueDate, followUpDate, candidateUsers, candidateGroups, priority, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Changeset {\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    candidateUsers: ").append(toIndentedString(candidateUsers)).append("\n");
    sb.append("    candidateGroups: ").append(toIndentedString(candidateGroups)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

