package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.camunda.zeebe.gateway.protocol.rest.Partition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Provides information on a broker node.
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Schema(name = "BrokerInfo", description = "Provides information on a broker node.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class BrokerInfo {

  private Integer nodeId;

  private String host;

  private Integer port;

  @Valid
  private List<@Valid Partition> partitions = new ArrayList<>();

  private String version;

  public BrokerInfo nodeId(Integer nodeId) {
    this.nodeId = nodeId;
    return this;
  }

  /**
   * The unique (within a cluster) node ID for the broker.
   * @return nodeId
   */
  
  @Schema(name = "nodeId", description = "The unique (within a cluster) node ID for the broker.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("nodeId")
  public Integer getNodeId() {
    return nodeId;
  }

  public void setNodeId(Integer nodeId) {
    this.nodeId = nodeId;
  }

  public BrokerInfo host(String host) {
    this.host = host;
    return this;
  }

  /**
   * The hostname for reaching the broker.
   * @return host
   */
  
  @Schema(name = "host", description = "The hostname for reaching the broker.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("host")
  public String getHost() {
    return host;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public BrokerInfo port(Integer port) {
    this.port = port;
    return this;
  }

  /**
   * The port for reaching the broker.
   * @return port
   */
  
  @Schema(name = "port", description = "The port for reaching the broker.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("port")
  public Integer getPort() {
    return port;
  }

  public void setPort(Integer port) {
    this.port = port;
  }

  public BrokerInfo partitions(List<@Valid Partition> partitions) {
    this.partitions = partitions;
    return this;
  }

  public BrokerInfo addPartitionsItem(Partition partitionsItem) {
    if (this.partitions == null) {
      this.partitions = new ArrayList<>();
    }
    this.partitions.add(partitionsItem);
    return this;
  }

  /**
   * A list of partitions managed or replicated on this broker.
   * @return partitions
   */
  @Valid 
  @Schema(name = "partitions", description = "A list of partitions managed or replicated on this broker.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("partitions")
  public List<@Valid Partition> getPartitions() {
    return partitions;
  }

  public void setPartitions(List<@Valid Partition> partitions) {
    this.partitions = partitions;
  }

  public BrokerInfo version(String version) {
    this.version = version;
    return this;
  }

  /**
   * The broker version.
   * @return version
   */
  
  @Schema(name = "version", description = "The broker version.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BrokerInfo brokerInfo = (BrokerInfo) o;
    return Objects.equals(this.nodeId, brokerInfo.nodeId) &&
        Objects.equals(this.host, brokerInfo.host) &&
        Objects.equals(this.port, brokerInfo.port) &&
        Objects.equals(this.partitions, brokerInfo.partitions) &&
        Objects.equals(this.version, brokerInfo.version);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nodeId, host, port, partitions, version);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BrokerInfo {\n");
    sb.append("    nodeId: ").append(toIndentedString(nodeId)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    partitions: ").append(toIndentedString(partitions)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

