package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * AuthorizationPatchRequestPermissionsInner
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@JsonTypeName("AuthorizationPatchRequest_permissions_inner")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class AuthorizationPatchRequestPermissionsInner {

  /**
   * Specifies the type of permissions.
   */
  public enum PermissionTypeEnum {
    CREATE("CREATE"),
    
    READ("READ"),
    
    UPDATE("UPDATE"),
    
    DELETE("DELETE");

    private String value;

    PermissionTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PermissionTypeEnum fromValue(String value) {
      for (PermissionTypeEnum b : PermissionTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private PermissionTypeEnum permissionType;

  @Valid
  private List<String> resourceIds = new ArrayList<>();

  public AuthorizationPatchRequestPermissionsInner permissionType(PermissionTypeEnum permissionType) {
    this.permissionType = permissionType;
    return this;
  }

  /**
   * Specifies the type of permissions.
   * @return permissionType
   */
  
  @Schema(name = "permissionType", description = "Specifies the type of permissions.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("permissionType")
  public PermissionTypeEnum getPermissionType() {
    return permissionType;
  }

  public void setPermissionType(PermissionTypeEnum permissionType) {
    this.permissionType = permissionType;
  }

  public AuthorizationPatchRequestPermissionsInner resourceIds(List<String> resourceIds) {
    this.resourceIds = resourceIds;
    return this;
  }

  public AuthorizationPatchRequestPermissionsInner addResourceIdsItem(String resourceIdsItem) {
    if (this.resourceIds == null) {
      this.resourceIds = new ArrayList<>();
    }
    this.resourceIds.add(resourceIdsItem);
    return this;
  }

  /**
   * A list of resource IDs the permission relates to.
   * @return resourceIds
   */
  
  @Schema(name = "resourceIds", description = "A list of resource IDs the permission relates to.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceIds")
  public List<String> getResourceIds() {
    return resourceIds;
  }

  public void setResourceIds(List<String> resourceIds) {
    this.resourceIds = resourceIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationPatchRequestPermissionsInner authorizationPatchRequestPermissionsInner = (AuthorizationPatchRequestPermissionsInner) o;
    return Objects.equals(this.permissionType, authorizationPatchRequestPermissionsInner.permissionType) &&
        Objects.equals(this.resourceIds, authorizationPatchRequestPermissionsInner.resourceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(permissionType, resourceIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationPatchRequestPermissionsInner {\n");
    sb.append("    permissionType: ").append(toIndentedString(permissionType)).append("\n");
    sb.append("    resourceIds: ").append(toIndentedString(resourceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

