package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.zeebe.gateway.protocol.rest.AuthorizationPatchRequestPermissionsInner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * AuthorizationPatchRequest
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class AuthorizationPatchRequest {

  /**
   * Indicates if permissions should be added or removed.
   */
  public enum ActionEnum {
    ADD("ADD"),
    
    REMOVE("REMOVE");

    private String value;

    ActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ActionEnum fromValue(String value) {
      for (ActionEnum b : ActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private ActionEnum action;

  /**
   * The type of resource to add/remove perissions to/from.
   */
  public enum ResourceTypeEnum {
    AUTHORIZATION("AUTHORIZATION"),
    
    MESSAGE("MESSAGE"),
    
    JOB("JOB"),
    
    APPLICATION("APPLICATION"),
    
    TENANT("TENANT"),
    
    DEPLOYMENT("DEPLOYMENT"),
    
    PROCESS_DEFINITION("PROCESS_DEFINITION"),
    
    USER_TASK("USER_TASK"),
    
    DECISION_REQUIREMENTS_DEFINITION("DECISION_REQUIREMENTS_DEFINITION"),
    
    DECISION_DEFINITION("DECISION_DEFINITION"),
    
    USER_GROUP("USER_GROUP"),
    
    USER("USER"),
    
    ROLE("ROLE");

    private String value;

    ResourceTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ResourceTypeEnum fromValue(String value) {
      for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private ResourceTypeEnum resourceType;

  @Valid
  private List<@Valid AuthorizationPatchRequestPermissionsInner> permissions = new ArrayList<>();

  public AuthorizationPatchRequest action(ActionEnum action) {
    this.action = action;
    return this;
  }

  /**
   * Indicates if permissions should be added or removed.
   * @return action
   */
  
  @Schema(name = "action", description = "Indicates if permissions should be added or removed.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("action")
  public ActionEnum getAction() {
    return action;
  }

  public void setAction(ActionEnum action) {
    this.action = action;
  }

  public AuthorizationPatchRequest resourceType(ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
    return this;
  }

  /**
   * The type of resource to add/remove perissions to/from.
   * @return resourceType
   */
  
  @Schema(name = "resourceType", description = "The type of resource to add/remove perissions to/from.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("resourceType")
  public ResourceTypeEnum getResourceType() {
    return resourceType;
  }

  public void setResourceType(ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
  }

  public AuthorizationPatchRequest permissions(List<@Valid AuthorizationPatchRequestPermissionsInner> permissions) {
    this.permissions = permissions;
    return this;
  }

  public AuthorizationPatchRequest addPermissionsItem(AuthorizationPatchRequestPermissionsInner permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

  /**
   * The permissions to add/remove.
   * @return permissions
   */
  @Valid 
  @Schema(name = "permissions", description = "The permissions to add/remove.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("permissions")
  public List<@Valid AuthorizationPatchRequestPermissionsInner> getPermissions() {
    return permissions;
  }

  public void setPermissions(List<@Valid AuthorizationPatchRequestPermissionsInner> permissions) {
    this.permissions = permissions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationPatchRequest authorizationPatchRequest = (AuthorizationPatchRequest) o;
    return Objects.equals(this.action, authorizationPatchRequest.action) &&
        Objects.equals(this.resourceType, authorizationPatchRequest.resourceType) &&
        Objects.equals(this.permissions, authorizationPatchRequest.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(action, resourceType, permissions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationPatchRequest {\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

