package io.camunda.zeebe.gateway.protocol.rest;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ActivatedJob
 */
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-10-11T17:26:39.504605721Z[GMT]", comments = "Generator version: 7.8.0")
public class ActivatedJob {

  private Long jobKey;

  private String type;

  private Long processInstanceKey;

  private String processDefinitionId;

  private Integer processDefinitionVersion;

  private Long processDefinitionKey;

  private String elementId;

  private Long elementInstanceKey;

  @Valid
  private Map<String, Object> customHeaders = new HashMap<>();

  private String worker;

  private Integer retries;

  private Long deadline;

  @Valid
  private Map<String, Object> variables = new HashMap<>();

  private String tenantId;

  public ActivatedJob jobKey(Long jobKey) {
    this.jobKey = jobKey;
    return this;
  }

  /**
   * the key, a unique identifier for the job
   * @return jobKey
   */
  
  @Schema(name = "jobKey", description = "the key, a unique identifier for the job", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("jobKey")
  public Long getJobKey() {
    return jobKey;
  }

  public void setJobKey(Long jobKey) {
    this.jobKey = jobKey;
  }

  public ActivatedJob type(String type) {
    this.type = type;
    return this;
  }

  /**
   * the type of the job (should match what was requested)
   * @return type
   */
  
  @Schema(name = "type", description = "the type of the job (should match what was requested)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public ActivatedJob processInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * the job's process instance key
   * @return processInstanceKey
   */
  
  @Schema(name = "processInstanceKey", description = "the job's process instance key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processInstanceKey")
  public Long getProcessInstanceKey() {
    return processInstanceKey;
  }

  public void setProcessInstanceKey(Long processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ActivatedJob processDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * the bpmn process ID of the job's process definition
   * @return processDefinitionId
   */
  
  @Schema(name = "processDefinitionId", description = "the bpmn process ID of the job's process definition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionId")
  public String getProcessDefinitionId() {
    return processDefinitionId;
  }

  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ActivatedJob processDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * the version of the job's process definition
   * @return processDefinitionVersion
   */
  
  @Schema(name = "processDefinitionVersion", description = "the version of the job's process definition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionVersion")
  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ActivatedJob processDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * the key of the job's process definition
   * @return processDefinitionKey
   */
  
  @Schema(name = "processDefinitionKey", description = "the key of the job's process definition", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("processDefinitionKey")
  public Long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  public void setProcessDefinitionKey(Long processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ActivatedJob elementId(String elementId) {
    this.elementId = elementId;
    return this;
  }

  /**
   * the associated task element ID
   * @return elementId
   */
  
  @Schema(name = "elementId", description = "the associated task element ID", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("elementId")
  public String getElementId() {
    return elementId;
  }

  public void setElementId(String elementId) {
    this.elementId = elementId;
  }

  public ActivatedJob elementInstanceKey(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * the unique key identifying the associated task, unique within the scope of the process instance 
   * @return elementInstanceKey
   */
  
  @Schema(name = "elementInstanceKey", description = "the unique key identifying the associated task, unique within the scope of the process instance ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("elementInstanceKey")
  public Long getElementInstanceKey() {
    return elementInstanceKey;
  }

  public void setElementInstanceKey(Long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public ActivatedJob customHeaders(Map<String, Object> customHeaders) {
    this.customHeaders = customHeaders;
    return this;
  }

  public ActivatedJob putCustomHeadersItem(String key, Object customHeadersItem) {
    if (this.customHeaders == null) {
      this.customHeaders = new HashMap<>();
    }
    this.customHeaders.put(key, customHeadersItem);
    return this;
  }

  /**
   * a set of custom headers defined during modelling; returned as a serialized JSON document
   * @return customHeaders
   */
  
  @Schema(name = "customHeaders", description = "a set of custom headers defined during modelling; returned as a serialized JSON document", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("customHeaders")
  public Map<String, Object> getCustomHeaders() {
    return customHeaders;
  }

  public void setCustomHeaders(Map<String, Object> customHeaders) {
    this.customHeaders = customHeaders;
  }

  public ActivatedJob worker(String worker) {
    this.worker = worker;
    return this;
  }

  /**
   * the name of the worker which activated this job
   * @return worker
   */
  
  @Schema(name = "worker", description = "the name of the worker which activated this job", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("worker")
  public String getWorker() {
    return worker;
  }

  public void setWorker(String worker) {
    this.worker = worker;
  }

  public ActivatedJob retries(Integer retries) {
    this.retries = retries;
    return this;
  }

  /**
   * the amount of retries left to this job (should always be positive)
   * @return retries
   */
  
  @Schema(name = "retries", description = "the amount of retries left to this job (should always be positive)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("retries")
  public Integer getRetries() {
    return retries;
  }

  public void setRetries(Integer retries) {
    this.retries = retries;
  }

  public ActivatedJob deadline(Long deadline) {
    this.deadline = deadline;
    return this;
  }

  /**
   * when the job can be activated again, sent as a UNIX epoch timestamp
   * @return deadline
   */
  
  @Schema(name = "deadline", description = "when the job can be activated again, sent as a UNIX epoch timestamp", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("deadline")
  public Long getDeadline() {
    return deadline;
  }

  public void setDeadline(Long deadline) {
    this.deadline = deadline;
  }

  public ActivatedJob variables(Map<String, Object> variables) {
    this.variables = variables;
    return this;
  }

  public ActivatedJob putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All variables visible to the task scope, computed at activation time
   * @return variables
   */
  
  @Schema(name = "variables", description = "All variables visible to the task scope, computed at activation time", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("variables")
  public Map<String, Object> getVariables() {
    return variables;
  }

  public void setVariables(Map<String, Object> variables) {
    this.variables = variables;
  }

  public ActivatedJob tenantId(String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The ID of the tenant that owns the job
   * @return tenantId
   */
  
  @Schema(name = "tenantId", description = "The ID of the tenant that owns the job", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tenantId")
  public String getTenantId() {
    return tenantId;
  }

  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ActivatedJob activatedJob = (ActivatedJob) o;
    return Objects.equals(this.jobKey, activatedJob.jobKey) &&
        Objects.equals(this.type, activatedJob.type) &&
        Objects.equals(this.processInstanceKey, activatedJob.processInstanceKey) &&
        Objects.equals(this.processDefinitionId, activatedJob.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, activatedJob.processDefinitionVersion) &&
        Objects.equals(this.processDefinitionKey, activatedJob.processDefinitionKey) &&
        Objects.equals(this.elementId, activatedJob.elementId) &&
        Objects.equals(this.elementInstanceKey, activatedJob.elementInstanceKey) &&
        Objects.equals(this.customHeaders, activatedJob.customHeaders) &&
        Objects.equals(this.worker, activatedJob.worker) &&
        Objects.equals(this.retries, activatedJob.retries) &&
        Objects.equals(this.deadline, activatedJob.deadline) &&
        Objects.equals(this.variables, activatedJob.variables) &&
        Objects.equals(this.tenantId, activatedJob.tenantId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(jobKey, type, processInstanceKey, processDefinitionId, processDefinitionVersion, processDefinitionKey, elementId, elementInstanceKey, customHeaders, worker, retries, deadline, variables, tenantId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ActivatedJob {\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    customHeaders: ").append(toIndentedString(customHeaders)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

