/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dmn.impl;

import io.camunda.zeebe.dmn.EvaluatedInput;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.camunda.dmn.Audit;
import org.camunda.dmn.parser.FeelExpression;
import org.camunda.dmn.parser.ParsedExpression;
import org.camunda.dmn.parser.ParsedInput;
import org.camunda.feel.syntaxtree.Val;

public record EvaluatedDmnScalaInput(String inputId, String inputName, DirectBuffer inputValue) implements EvaluatedInput
{
    private static final String MAX_EXPRESSION_LENGTH = "30";
    private static final String TRUNCATE_EXPRESSION_TEMPLATE = "%.30s";

    public static EvaluatedDmnScalaInput of(Audit.EvaluatedInput evaluatedInput, Function<Val, DirectBuffer> converter) {
        ParsedInput input = evaluatedInput.input();
        Val inputValue = evaluatedInput.value();
        String inputName = EvaluatedDmnScalaInput.determineInputName(input);
        return new EvaluatedDmnScalaInput(input.id(), inputName, converter.apply(inputValue));
    }

    private static String determineInputName(ParsedInput input) {
        String inputName;
        if (input.name() != null) {
            inputName = input.name();
        } else {
            ParsedExpression parsedExpression = input.expression();
            if (parsedExpression instanceof FeelExpression) {
                FeelExpression feelExpression = (FeelExpression)parsedExpression;
                inputName = EvaluatedDmnScalaInput.truncateExpression(feelExpression.expression().text());
            } else {
                inputName = null;
            }
        }
        return inputName;
    }

    private static String truncateExpression(String text) {
        if (text == null) {
            return null;
        }
        return TRUNCATE_EXPRESSION_TEMPLATE.formatted(text);
    }
}

