/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.metrics;

import io.camunda.zeebe.db.impl.rocksdb.metrics.RocksDbMetricsDoc;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksDBMetricExporter {
    private static final Logger LOG = LoggerFactory.getLogger((String)RocksDBMetricExporter.class.getName());
    private final Map<RocksDbMetricsDoc, StatefulGauge> metrics = new EnumMap<RocksDbMetricsDoc, StatefulGauge>(RocksDbMetricsDoc.class);
    private final MeterRegistry registry;

    public RocksDBMetricExporter(MeterRegistry registry) {
        this.registry = registry;
    }

    public void exportMetrics(RocksDB database) {
        long startTime = System.nanoTime();
        for (RocksDbMetricsDoc metric : RocksDbMetricsDoc.values()) {
            StatefulGauge gauge = this.metrics.computeIfAbsent(metric, this::registerMetric);
            this.exportMetric(database, metric.propertyName(), gauge);
        }
        long elapsedTime = System.nanoTime() - startTime;
        LOG.trace("Exporting RocksDBMetrics took + {} ms", (Object)TimeUnit.MILLISECONDS.convert(elapsedTime, TimeUnit.NANOSECONDS));
    }

    private StatefulGauge registerMetric(RocksDbMetricsDoc doc) {
        return StatefulGauge.builder((String)doc.getName()).description(doc.getDescription()).register(this.registry);
    }

    private void exportMetric(RocksDB database, String propertyName, StatefulGauge gauge) {
        try {
            String value = database.getProperty(propertyName);
            if (value != null) {
                gauge.set(Double.parseDouble(value));
            }
        }
        catch (Exception exception) {
            LOG.debug("Error occurred on exporting metric {}", (Object)propertyName, (Object)exception);
        }
    }
}

