/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.serializer;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import io.atomix.cluster.MemberId;
import io.atomix.utils.AbstractIdentifier;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationChangeResponse;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationManagementRequest;
import io.camunda.zeebe.dynamic.config.api.ErrorResponse;
import io.camunda.zeebe.dynamic.config.gossip.ClusterConfigurationGossipState;
import io.camunda.zeebe.dynamic.config.protocol.Requests;
import io.camunda.zeebe.dynamic.config.protocol.Topology;
import io.camunda.zeebe.dynamic.config.serializer.ClusterConfigurationRequestsSerializer;
import io.camunda.zeebe.dynamic.config.serializer.ClusterConfigurationSerializer;
import io.camunda.zeebe.dynamic.config.serializer.DecodingFailed;
import io.camunda.zeebe.dynamic.config.state.ClusterChangePlan;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.CompletedChange;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.ExporterState;
import io.camunda.zeebe.dynamic.config.state.ExportersConfig;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProtoBufSerializer
implements ClusterConfigurationSerializer,
ClusterConfigurationRequestsSerializer {
    @Override
    public byte[] encode(ClusterConfigurationGossipState gossipState) {
        Topology.GossipState.Builder builder = Topology.GossipState.newBuilder();
        ClusterConfiguration topologyToEncode = gossipState.getClusterConfiguration();
        if (topologyToEncode != null) {
            Topology.ClusterTopology clusterTopology = this.encodeClusterTopology(topologyToEncode);
            builder.setClusterTopology(clusterTopology);
        }
        Topology.GossipState message = builder.build();
        return message.toByteArray();
    }

    @Override
    public ClusterConfigurationGossipState decode(byte[] encodedState) {
        Topology.GossipState gossipState;
        try {
            gossipState = Topology.GossipState.parseFrom(encodedState);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
        ClusterConfigurationGossipState clusterConfigurationGossipState = new ClusterConfigurationGossipState();
        if (gossipState.hasClusterTopology()) {
            try {
                clusterConfigurationGossipState.setClusterConfiguration(this.decodeClusterTopology(gossipState.getClusterTopology()));
            }
            catch (Exception e) {
                throw new DecodingFailed("Cluster topology could not be deserialized from gossiped state: %s".formatted(gossipState), e);
            }
        }
        return clusterConfigurationGossipState;
    }

    @Override
    public byte[] encode(ClusterConfiguration clusterConfiguration) {
        return this.encodeClusterTopology(clusterConfiguration).toByteArray();
    }

    @Override
    public ClusterConfiguration decodeClusterTopology(byte[] encodedClusterTopology, int offset, int length) {
        try {
            Topology.ClusterTopology topology = Topology.ClusterTopology.parseFrom(ByteBuffer.wrap(encodedClusterTopology, offset, length));
            return this.decodeClusterTopology(topology);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    private ClusterConfiguration decodeClusterTopology(Topology.ClusterTopology encodedClusterTopology) {
        Map<MemberId, MemberState> members = this.decodeMemberStateMap(encodedClusterTopology.getMembersMap());
        Optional<CompletedChange> completedChange = encodedClusterTopology.hasLastChange() ? Optional.of(this.decodeCompletedChange(encodedClusterTopology.getLastChange())) : Optional.empty();
        Optional<ClusterChangePlan> currentChange = encodedClusterTopology.hasCurrentChange() ? Optional.of(this.decodeChangePlan(encodedClusterTopology.getCurrentChange())) : Optional.empty();
        Optional<RoutingState> routingState = encodedClusterTopology.hasRoutingState() ? Optional.of(this.decodeRoutingState(encodedClusterTopology.getRoutingState())) : Optional.empty();
        return new ClusterConfiguration(encodedClusterTopology.getVersion(), members, completedChange, currentChange, routingState);
    }

    private Map<MemberId, MemberState> decodeMemberStateMap(Map<String, Topology.MemberState> membersMap) {
        return membersMap.entrySet().stream().map(e -> Map.entry(MemberId.from((String)((String)e.getKey())), this.decodeMemberState((Topology.MemberState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Topology.ClusterTopology encodeClusterTopology(ClusterConfiguration clusterConfiguration) {
        Map<String, Topology.MemberState> members = this.encodeMemberStateMap(clusterConfiguration.members());
        Topology.ClusterTopology.Builder builder = Topology.ClusterTopology.newBuilder().setVersion(clusterConfiguration.version()).putAllMembers(members);
        clusterConfiguration.lastChange().ifPresent(lastChange -> builder.setLastChange(this.encodeCompletedChange((CompletedChange)lastChange)));
        clusterConfiguration.pendingChanges().ifPresent(changePlan -> builder.setCurrentChange(this.encodeChangePlan((ClusterChangePlan)changePlan)));
        clusterConfiguration.routingState().ifPresent(routingState -> builder.setRoutingState(this.encodeRoutingState((RoutingState)routingState)));
        return builder.build();
    }

    private MemberState decodeMemberState(Topology.MemberState memberState) {
        Map<Integer, PartitionState> partitions = memberState.getPartitionsMap().entrySet().stream().map(e -> Map.entry((Integer)e.getKey(), this.decodePartitionState((Topology.PartitionState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Timestamp lastUpdated = memberState.getLastUpdated();
        return new MemberState(memberState.getVersion(), Instant.ofEpochSecond(lastUpdated.getSeconds(), lastUpdated.getNanos()), this.toMemberState(memberState.getState()), partitions);
    }

    private PartitionState decodePartitionState(Topology.PartitionState partitionState) {
        if (partitionState.hasConfig()) {
            return new PartitionState(this.toPartitionState(partitionState.getState()), partitionState.getPriority(), this.decodePartitionConfig(partitionState.getConfig()));
        }
        return new PartitionState(this.toPartitionState(partitionState.getState()), partitionState.getPriority(), DynamicPartitionConfig.uninitialized());
    }

    private DynamicPartitionConfig decodePartitionConfig(Topology.PartitionConfig config) {
        return new DynamicPartitionConfig(this.decodeExportingConfig(config.getExporting()));
    }

    private ExportersConfig decodeExportingConfig(Topology.ExportersConfig exporting) {
        return new ExportersConfig(exporting.getExportersMap().entrySet().stream().map(e -> Map.entry((String)e.getKey(), this.decodeExporterState((Topology.ExporterState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private ExporterState decodeExporterState(Topology.ExporterState value) {
        Optional<String> initializeFrom = value.hasInitializedFrom() ? Optional.of(value.getInitializedFrom()) : Optional.empty();
        return switch (value.getState()) {
            default -> throw new MatchException(null, null);
            case Topology.EnabledDisabledState.ENABLED -> new ExporterState(value.getMetadataVersion(), ExporterState.State.ENABLED, initializeFrom);
            case Topology.EnabledDisabledState.DISABLED -> new ExporterState(value.getMetadataVersion(), ExporterState.State.DISABLED, initializeFrom);
            case Topology.EnabledDisabledState.UNRECOGNIZED, Topology.EnabledDisabledState.ENABLED_DISBALED_UNKNOWN -> throw new IllegalStateException("Unknown exporter state " + String.valueOf((Object)value.getState()));
        };
    }

    private Topology.MemberState encodeMemberState(MemberState memberState) {
        Map<Integer, Topology.PartitionState> partitions = memberState.partitions().entrySet().stream().map(e -> Map.entry((Integer)e.getKey(), this.encodePartitions((PartitionState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Instant lastUpdated = memberState.lastUpdated();
        return Topology.MemberState.newBuilder().setVersion(memberState.version()).setLastUpdated(Timestamp.newBuilder().setSeconds(lastUpdated.getEpochSecond()).setNanos(lastUpdated.getNano()).build()).setState(this.toSerializedState(memberState.state())).putAllPartitions(partitions).build();
    }

    private Topology.PartitionState encodePartitions(PartitionState partitionState) {
        Topology.PartitionState.Builder builder = Topology.PartitionState.newBuilder().setState(this.toSerializedState(partitionState.state())).setPriority(partitionState.priority());
        if (partitionState.config().isInitialized()) {
            builder.setConfig(this.encodePartitionConfig(partitionState.config()));
        }
        return builder.build();
    }

    private Topology.PartitionConfig encodePartitionConfig(DynamicPartitionConfig config) {
        return Topology.PartitionConfig.newBuilder().setExporting(this.encodeExportingConfig(config.exporting())).build();
    }

    private Topology.ExportersConfig encodeExportingConfig(ExportersConfig exporting) {
        return Topology.ExportersConfig.newBuilder().putAllExporters(exporting.exporters().entrySet().stream().map(e -> Map.entry((String)e.getKey(), this.encodeExporterState((ExporterState)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).build();
    }

    private Topology.ExporterState encodeExporterState(ExporterState value) {
        Topology.EnabledDisabledState state = switch (value.state()) {
            default -> throw new MatchException(null, null);
            case ExporterState.State.ENABLED -> Topology.EnabledDisabledState.ENABLED;
            case ExporterState.State.DISABLED -> Topology.EnabledDisabledState.DISABLED;
        };
        Topology.ExporterState.Builder builder = Topology.ExporterState.newBuilder().setState(state).setMetadataVersion(value.metadataVersion());
        value.initializedFrom().ifPresent(builder::setInitializedFrom);
        return builder.build();
    }

    private Topology.State toSerializedState(MemberState.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case MemberState.State.UNINITIALIZED -> Topology.State.UNKNOWN;
            case MemberState.State.ACTIVE -> Topology.State.ACTIVE;
            case MemberState.State.JOINING -> Topology.State.JOINING;
            case MemberState.State.LEAVING -> Topology.State.LEAVING;
            case MemberState.State.LEFT -> Topology.State.LEFT;
        };
    }

    private MemberState.State toMemberState(Topology.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Topology.State.UNRECOGNIZED, Topology.State.UNKNOWN -> MemberState.State.UNINITIALIZED;
            case Topology.State.ACTIVE -> MemberState.State.ACTIVE;
            case Topology.State.JOINING -> MemberState.State.JOINING;
            case Topology.State.LEAVING -> MemberState.State.LEAVING;
            case Topology.State.LEFT -> MemberState.State.LEFT;
            case Topology.State.BOOTSTRAPPING -> throw new IllegalStateException("Member cannot be in BOOTSTRAPPING state");
        };
    }

    private PartitionState.State toPartitionState(Topology.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Topology.State.UNRECOGNIZED, Topology.State.UNKNOWN, Topology.State.LEFT -> PartitionState.State.UNKNOWN;
            case Topology.State.ACTIVE -> PartitionState.State.ACTIVE;
            case Topology.State.JOINING -> PartitionState.State.JOINING;
            case Topology.State.LEAVING -> PartitionState.State.LEAVING;
            case Topology.State.BOOTSTRAPPING -> PartitionState.State.BOOTSTRAPPING;
        };
    }

    private Topology.State toSerializedState(PartitionState.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case PartitionState.State.UNKNOWN -> Topology.State.UNKNOWN;
            case PartitionState.State.ACTIVE -> Topology.State.ACTIVE;
            case PartitionState.State.JOINING -> Topology.State.JOINING;
            case PartitionState.State.LEAVING -> Topology.State.LEAVING;
            case PartitionState.State.BOOTSTRAPPING -> Topology.State.BOOTSTRAPPING;
        };
    }

    private Topology.ClusterChangePlan encodeChangePlan(ClusterChangePlan changes) {
        Topology.ClusterChangePlan.Builder builder = Topology.ClusterChangePlan.newBuilder().setVersion(changes.version()).setId(changes.id()).setStatus(this.fromTopologyChangeStatus(changes.status())).setStartedAt(Timestamp.newBuilder().setSeconds(changes.startedAt().getEpochSecond()).setNanos(changes.startedAt().getNano()).build());
        changes.pendingOperations().forEach(operation -> builder.addPendingOperations(this.encodeOperation((ClusterConfigurationChangeOperation)operation)));
        changes.completedOperations().forEach(operation -> builder.addCompletedOperations(this.encodeCompletedOperation((ClusterChangePlan.CompletedOperation)operation)));
        return builder.build();
    }

    private Topology.CompletedChange encodeCompletedChange(CompletedChange completedChange) {
        Topology.CompletedChange.Builder builder = Topology.CompletedChange.newBuilder();
        builder.setId(completedChange.id()).setStatus(this.fromTopologyChangeStatus(completedChange.status())).setCompletedAt(Timestamp.newBuilder().setSeconds(completedChange.completedAt().getEpochSecond()).setNanos(completedChange.completedAt().getNano()).build()).setStartedAt(Timestamp.newBuilder().setSeconds(completedChange.startedAt().getEpochSecond()).setNanos(completedChange.startedAt().getNano()).build());
        return builder.build();
    }

    private Topology.TopologyChangeOperation encodeOperation(ClusterConfigurationChangeOperation operation) {
        Topology.TopologyChangeOperation.Builder builder = Topology.TopologyChangeOperation.newBuilder().setMemberId((String)((Object)operation.memberId().id()));
        ClusterConfigurationChangeOperation clusterConfigurationChangeOperation = operation;
        Objects.requireNonNull(clusterConfigurationChangeOperation);
        ClusterConfigurationChangeOperation clusterConfigurationChangeOperation2 = clusterConfigurationChangeOperation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation.class, ClusterConfigurationChangeOperation.MemberJoinOperation.class, ClusterConfigurationChangeOperation.MemberLeaveOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation.class, ClusterConfigurationChangeOperation.MemberRemoveOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation.class}, (Object)clusterConfigurationChangeOperation2, n)) {
            case 0: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation joinOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionJoin(Topology.PartitionJoinOperation.newBuilder().setPartitionId(joinOperation.partitionId()).setPriority(joinOperation.priority()));
                break;
            }
            case 1: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leaveOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionLeave(Topology.PartitionLeaveOperation.newBuilder().setPartitionId(leaveOperation.partitionId()));
                break;
            }
            case 2: {
                ClusterConfigurationChangeOperation.MemberJoinOperation memberJoinOperation = (ClusterConfigurationChangeOperation.MemberJoinOperation)clusterConfigurationChangeOperation2;
                builder.setMemberJoin(Topology.MemberJoinOperation.newBuilder().build());
                break;
            }
            case 3: {
                ClusterConfigurationChangeOperation.MemberLeaveOperation memberLeaveOperation = (ClusterConfigurationChangeOperation.MemberLeaveOperation)clusterConfigurationChangeOperation2;
                builder.setMemberLeave(Topology.MemberLeaveOperation.newBuilder().build());
                break;
            }
            case 4: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation reconfigurePriorityOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionReconfigurePriority(Topology.PartitionReconfigurePriorityOperation.newBuilder().setPartitionId(reconfigurePriorityOperation.partitionId()).setPriority(reconfigurePriorityOperation.priority()).build());
                break;
            }
            case 5: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation forceReconfigureOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionForceReconfigure(Topology.PartitionForceReconfigureOperation.newBuilder().setPartitionId(forceReconfigureOperation.partitionId()).addAllMembers(forceReconfigureOperation.members().stream().map(AbstractIdentifier::id).toList()).build());
                break;
            }
            case 6: {
                ClusterConfigurationChangeOperation.MemberRemoveOperation memberRemoveOperation = (ClusterConfigurationChangeOperation.MemberRemoveOperation)clusterConfigurationChangeOperation2;
                builder.setMemberRemove(Topology.MemberRemoveOperation.newBuilder().setMemberToRemove((String)((Object)memberRemoveOperation.memberToRemove().id())).build());
                break;
            }
            case 7: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation disableExporterOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionDisableExporter(Topology.PartitionDisableExporterOperation.newBuilder().setPartitionId(disableExporterOperation.partitionId()).setExporterId(disableExporterOperation.exporterId()).build());
                break;
            }
            case 8: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation enableExporterOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionEnableExporter(this.encodeEnabledExporterOperation(enableExporterOperation));
                break;
            }
            case 9: {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation bootstrapOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation)clusterConfigurationChangeOperation2;
                builder.setPartitionBootstrap(Topology.PartitionBootstrapOperation.newBuilder().setPartitionId(bootstrapOperation.partitionId()).setPriority(bootstrapOperation.priority()).build());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type: " + operation.getClass().getSimpleName());
            }
        }
        return builder.build();
    }

    private Topology.PartitionEnableExporterOperation encodeEnabledExporterOperation(ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation enableExporterOperation) {
        Topology.PartitionEnableExporterOperation.Builder enableExporterOperationBuilder = Topology.PartitionEnableExporterOperation.newBuilder().setPartitionId(enableExporterOperation.partitionId()).setExporterId(enableExporterOperation.exporterId());
        enableExporterOperation.initializeFrom().ifPresent(enableExporterOperationBuilder::setInitializeFrom);
        return enableExporterOperationBuilder.build();
    }

    private Topology.CompletedTopologyChangeOperation encodeCompletedOperation(ClusterChangePlan.CompletedOperation completedOperation) {
        return Topology.CompletedTopologyChangeOperation.newBuilder().setOperation(this.encodeOperation(completedOperation.operation())).setCompletedAt(Timestamp.newBuilder().setSeconds(completedOperation.completedAt().getEpochSecond()).setNanos(completedOperation.completedAt().getNano()).build()).build();
    }

    private ClusterChangePlan decodeChangePlan(Topology.ClusterChangePlan clusterChangePlan) {
        List<ClusterConfigurationChangeOperation> pendingOperations = clusterChangePlan.getPendingOperationsList().stream().map(this::decodeOperation).toList();
        List<ClusterChangePlan.CompletedOperation> completedOperations = clusterChangePlan.getCompletedOperationsList().stream().map(this::decodeCompletedOperation).toList();
        return new ClusterChangePlan(clusterChangePlan.getId(), clusterChangePlan.getVersion(), this.toChangeStatus(clusterChangePlan.getStatus()), Instant.ofEpochSecond(clusterChangePlan.getStartedAt().getSeconds(), clusterChangePlan.getStartedAt().getNanos()), completedOperations, pendingOperations);
    }

    private RoutingState decodeRoutingState(Topology.RoutingState routingState) {
        return new RoutingState(routingState.getVersion(), new HashSet<Integer>(routingState.getActivePartitionsList()), this.decodeMessageCorrelation(routingState.getMessageCorrelation()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RoutingState.MessageCorrelation decodeMessageCorrelation(Topology.MessageCorrelation messageCorrelation) {
        switch (messageCorrelation.getCorrelationCase()) {
            default: {
                throw new MatchException(null, null);
            }
            case HASHMOD: {
                return new RoutingState.MessageCorrelation.HashMod(messageCorrelation.getHashMod().getPartitionCount());
            }
            case CORRELATION_NOT_SET: {
                throw new IllegalArgumentException("Unknown message correlation type");
            }
        }
    }

    private Topology.RoutingState encodeRoutingState(RoutingState routingState) {
        return Topology.RoutingState.newBuilder().setVersion(routingState.version()).addAllActivePartitions(routingState.activePartitions()).setMessageCorrelation(this.encodeMessageCorrelation(routingState.messageCorrelation())).build();
    }

    private Topology.MessageCorrelation encodeMessageCorrelation(RoutingState.MessageCorrelation correlation) {
        RoutingState.MessageCorrelation messageCorrelation = correlation;
        Objects.requireNonNull(messageCorrelation);
        RoutingState.MessageCorrelation messageCorrelation2 = messageCorrelation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RoutingState.MessageCorrelation.HashMod.class}, (Object)messageCorrelation2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        RoutingState.MessageCorrelation.HashMod hashMod = (RoutingState.MessageCorrelation.HashMod)messageCorrelation2;
        try {
            int n2;
            int partitionCount = n2 = hashMod.partitionCount();
            return Topology.MessageCorrelation.newBuilder().setHashMod(Topology.MessageCorrelation.HashMod.newBuilder().setPartitionCount(partitionCount)).build();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private CompletedChange decodeCompletedChange(Topology.CompletedChange completedChange) {
        return new CompletedChange(completedChange.getId(), this.toChangeStatus(completedChange.getStatus()), Instant.ofEpochSecond(completedChange.getStartedAt().getSeconds(), completedChange.getStartedAt().getNanos()), Instant.ofEpochSecond(completedChange.getCompletedAt().getSeconds(), completedChange.getCompletedAt().getNanos()));
    }

    private ClusterConfigurationChangeOperation decodeOperation(Topology.TopologyChangeOperation topologyChangeOperation) {
        if (topologyChangeOperation.hasPartitionJoin()) {
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionJoin().getPartitionId(), topologyChangeOperation.getPartitionJoin().getPriority());
        }
        if (topologyChangeOperation.hasPartitionLeave()) {
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionLeave().getPartitionId());
        }
        if (topologyChangeOperation.hasMemberJoin()) {
            return new ClusterConfigurationChangeOperation.MemberJoinOperation(MemberId.from((String)topologyChangeOperation.getMemberId()));
        }
        if (topologyChangeOperation.hasMemberLeave()) {
            return new ClusterConfigurationChangeOperation.MemberLeaveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()));
        }
        if (topologyChangeOperation.hasPartitionReconfigurePriority()) {
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionReconfigurePriority().getPartitionId(), topologyChangeOperation.getPartitionReconfigurePriority().getPriority());
        }
        if (topologyChangeOperation.hasPartitionForceReconfigure()) {
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionForceReconfigure().getPartitionId(), topologyChangeOperation.getPartitionForceReconfigure().getMembersList().stream().map(MemberId::from).toList());
        }
        if (topologyChangeOperation.hasMemberRemove()) {
            return new ClusterConfigurationChangeOperation.MemberRemoveOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), MemberId.from((String)topologyChangeOperation.getMemberRemove().getMemberToRemove()));
        }
        if (topologyChangeOperation.hasPartitionDisableExporter()) {
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionDisableExporter().getPartitionId(), topologyChangeOperation.getPartitionDisableExporter().getExporterId());
        }
        if (topologyChangeOperation.hasPartitionEnableExporter()) {
            Topology.PartitionEnableExporterOperation enableExporterOperation = topologyChangeOperation.getPartitionEnableExporter();
            Optional<String> initializeFrom = enableExporterOperation.hasInitializeFrom() ? Optional.of(enableExporterOperation.getInitializeFrom()) : Optional.empty();
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), enableExporterOperation.getPartitionId(), enableExporterOperation.getExporterId(), initializeFrom);
        }
        if (topologyChangeOperation.hasPartitionBootstrap()) {
            return new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation(MemberId.from((String)topologyChangeOperation.getMemberId()), topologyChangeOperation.getPartitionBootstrap().getPartitionId(), topologyChangeOperation.getPartitionBootstrap().getPriority());
        }
        throw new IllegalStateException("Unknown operation: " + String.valueOf(topologyChangeOperation));
    }

    private ClusterChangePlan.CompletedOperation decodeCompletedOperation(Topology.CompletedTopologyChangeOperation operation) {
        return new ClusterChangePlan.CompletedOperation(this.decodeOperation(operation.getOperation()), Instant.ofEpochSecond(operation.getCompletedAt().getSeconds()));
    }

    @Override
    public byte[] encodeAddMembersRequest(ClusterConfigurationManagementRequest.AddMembersRequest req) {
        return Requests.AddMembersRequest.newBuilder().addAllMemberIds(req.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeRemoveMembersRequest(ClusterConfigurationManagementRequest.RemoveMembersRequest req) {
        return Requests.RemoveMembersRequest.newBuilder().addAllMemberIds(req.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeJoinPartitionRequest(ClusterConfigurationManagementRequest.JoinPartitionRequest req) {
        return Requests.JoinPartitionRequest.newBuilder().setMemberId((String)((Object)req.memberId().id())).setPartitionId(req.partitionId()).setPriority(req.priority()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeLeavePartitionRequest(ClusterConfigurationManagementRequest.LeavePartitionRequest req) {
        return Requests.LeavePartitionRequest.newBuilder().setMemberId((String)((Object)req.memberId().id())).setPartitionId(req.partitionId()).setDryRun(req.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeReassignPartitionsRequest(ClusterConfigurationManagementRequest.ReassignPartitionsRequest reassignPartitionsRequest) {
        return Requests.ReassignAllPartitionsRequest.newBuilder().addAllMemberIds(reassignPartitionsRequest.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(reassignPartitionsRequest.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeScaleRequest(ClusterConfigurationManagementRequest.BrokerScaleRequest scaleRequest) {
        Requests.BrokerScaleRequest.Builder builder = Requests.BrokerScaleRequest.newBuilder().addAllMemberIds(scaleRequest.members().stream().map(AbstractIdentifier::id).toList()).setDryRun(scaleRequest.dryRun());
        scaleRequest.newReplicationFactor().ifPresent(builder::setNewReplicationFactor);
        return builder.build().toByteArray();
    }

    @Override
    public byte[] encodeCancelChangeRequest(ClusterConfigurationManagementRequest.CancelChangeRequest cancelChangeRequest) {
        return Requests.CancelTopologyChangeRequest.newBuilder().setChangeId(cancelChangeRequest.changeId()).build().toByteArray();
    }

    @Override
    public byte[] encodeExporterDisableRequest(ClusterConfigurationManagementRequest.ExporterDisableRequest exporterDisableRequest) {
        return Requests.ExporterDisableRequest.newBuilder().setExporterId(exporterDisableRequest.exporterId()).setDryRun(exporterDisableRequest.dryRun()).build().toByteArray();
    }

    @Override
    public byte[] encodeExporterEnableRequest(ClusterConfigurationManagementRequest.ExporterEnableRequest exporterEnableRequest) {
        Requests.ExporterEnableRequest.Builder builder = Requests.ExporterEnableRequest.newBuilder().setExporterId(exporterEnableRequest.exporterId()).setDryRun(exporterEnableRequest.dryRun());
        exporterEnableRequest.initializeFrom().ifPresent(builder::setInitializeFrom);
        return builder.build().toByteArray();
    }

    @Override
    public byte[] encodeClusterScaleRequest(ClusterConfigurationManagementRequest.ClusterScaleRequest clusterScaleRequest) {
        Requests.ClusterScaleRequest.Builder builder = Requests.ClusterScaleRequest.newBuilder().setDryRun(clusterScaleRequest.dryRun());
        clusterScaleRequest.newClusterSize().ifPresent(builder::setNewClusterSize);
        clusterScaleRequest.newReplicationFactor().ifPresent(builder::setNewReplicationFactor);
        clusterScaleRequest.newPartitionCount().ifPresent(builder::setNewPartitionCount);
        return builder.build().toByteArray();
    }

    @Override
    public byte[] encodeClusterPatchRequest(ClusterConfigurationManagementRequest.ClusterPatchRequest clusterPatchRequest) {
        Requests.ClusterPatchRequest.Builder builder = Requests.ClusterPatchRequest.newBuilder().setDryRun(clusterPatchRequest.dryRun());
        clusterPatchRequest.newPartitionCount().ifPresent(builder::setNewPartitionCount);
        clusterPatchRequest.newReplicationFactor().ifPresent(builder::setNewReplicationFactor);
        clusterPatchRequest.membersToAdd().stream().forEach(memberId -> builder.addMembersToAdd((String)((Object)memberId.id())));
        clusterPatchRequest.membersToRemove().stream().forEach(memberId -> builder.addMembersToRemove((String)((Object)memberId.id())));
        return builder.build().toByteArray();
    }

    @Override
    public byte[] encodeForceRemoveBrokersRequest(ClusterConfigurationManagementRequest.ForceRemoveBrokersRequest forceRemoveBrokersRequest) {
        return Requests.ForceRemoveBrokersRequest.newBuilder().addAllMembersToRemove(forceRemoveBrokersRequest.membersToRemove().stream().map(AbstractIdentifier::id).toList()).setDryRun(forceRemoveBrokersRequest.dryRun()).build().toByteArray();
    }

    @Override
    public ClusterConfigurationManagementRequest.AddMembersRequest decodeAddMembersRequest(byte[] encodedState) {
        try {
            Requests.AddMembersRequest addMemberRequest = Requests.AddMembersRequest.parseFrom(encodedState);
            return new ClusterConfigurationManagementRequest.AddMembersRequest(addMemberRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), addMemberRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.RemoveMembersRequest decodeRemoveMembersRequest(byte[] encodedState) {
        try {
            Requests.RemoveMembersRequest removeMemberRequest = Requests.RemoveMembersRequest.parseFrom(encodedState);
            return new ClusterConfigurationManagementRequest.RemoveMembersRequest(removeMemberRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), removeMemberRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.JoinPartitionRequest decodeJoinPartitionRequest(byte[] encodedState) {
        try {
            Requests.JoinPartitionRequest joinPartitionRequest = Requests.JoinPartitionRequest.parseFrom(encodedState);
            return new ClusterConfigurationManagementRequest.JoinPartitionRequest(MemberId.from((String)joinPartitionRequest.getMemberId()), joinPartitionRequest.getPartitionId(), joinPartitionRequest.getPriority(), joinPartitionRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.LeavePartitionRequest decodeLeavePartitionRequest(byte[] encodedState) {
        try {
            Requests.LeavePartitionRequest leavePartitionRequest = Requests.LeavePartitionRequest.parseFrom(encodedState);
            return new ClusterConfigurationManagementRequest.LeavePartitionRequest(MemberId.from((String)leavePartitionRequest.getMemberId()), leavePartitionRequest.getPartitionId(), leavePartitionRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.ReassignPartitionsRequest decodeReassignPartitionsRequest(byte[] encodedState) {
        try {
            Requests.ReassignAllPartitionsRequest reassignPartitionsRequest = Requests.ReassignAllPartitionsRequest.parseFrom(encodedState);
            return new ClusterConfigurationManagementRequest.ReassignPartitionsRequest(reassignPartitionsRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), reassignPartitionsRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.BrokerScaleRequest decodeScaleRequest(byte[] encodedState) {
        try {
            Requests.BrokerScaleRequest scaleRequest = Requests.BrokerScaleRequest.parseFrom(encodedState);
            Optional<Integer> newReplicationFactor = scaleRequest.hasNewReplicationFactor() ? Optional.of(scaleRequest.getNewReplicationFactor()) : Optional.empty();
            return new ClusterConfigurationManagementRequest.BrokerScaleRequest(scaleRequest.getMemberIdsList().stream().map(MemberId::from).collect(Collectors.toSet()), newReplicationFactor, scaleRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.CancelChangeRequest decodeCancelChangeRequest(byte[] encodedState) {
        try {
            Requests.CancelTopologyChangeRequest cancelChangeRequest = Requests.CancelTopologyChangeRequest.parseFrom(encodedState);
            return new ClusterConfigurationManagementRequest.CancelChangeRequest(cancelChangeRequest.getChangeId());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.ExporterDisableRequest decodeExporterDisableRequest(byte[] encodedRequest) {
        try {
            Requests.ExporterDisableRequest exporterDisableRequest = Requests.ExporterDisableRequest.parseFrom(encodedRequest);
            return new ClusterConfigurationManagementRequest.ExporterDisableRequest(exporterDisableRequest.getExporterId(), exporterDisableRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.ExporterEnableRequest decodeExporterEnableRequest(byte[] encodedRequest) {
        try {
            Requests.ExporterEnableRequest exporterEnableRequest = Requests.ExporterEnableRequest.parseFrom(encodedRequest);
            Optional<String> initializeFrom = exporterEnableRequest.hasInitializeFrom() ? Optional.of(exporterEnableRequest.getInitializeFrom()) : Optional.empty();
            return new ClusterConfigurationManagementRequest.ExporterEnableRequest(exporterEnableRequest.getExporterId(), initializeFrom, exporterEnableRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.ClusterScaleRequest decodeClusterScaleRequest(byte[] encodedRequest) {
        try {
            Requests.ClusterScaleRequest clusterScaleRequest = Requests.ClusterScaleRequest.parseFrom(encodedRequest);
            Optional<Integer> newClusterSize = clusterScaleRequest.hasNewClusterSize() ? Optional.of(clusterScaleRequest.getNewClusterSize()) : Optional.empty();
            Optional<Integer> newReplicationFactor = clusterScaleRequest.hasNewReplicationFactor() ? Optional.of(clusterScaleRequest.getNewReplicationFactor()) : Optional.empty();
            Optional<Integer> newPartitionCount = clusterScaleRequest.hasNewPartitionCount() ? Optional.of(clusterScaleRequest.getNewPartitionCount()) : Optional.empty();
            return new ClusterConfigurationManagementRequest.ClusterScaleRequest(newClusterSize, newPartitionCount, newReplicationFactor, clusterScaleRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.ClusterPatchRequest decodeClusterPatchRequest(byte[] encodedRequest) {
        try {
            Requests.ClusterPatchRequest clusterPatchRequest = Requests.ClusterPatchRequest.parseFrom(encodedRequest);
            Optional<Integer> newPartitionCount = clusterPatchRequest.hasNewPartitionCount() ? Optional.of(clusterPatchRequest.getNewPartitionCount()) : Optional.empty();
            Optional<Integer> newReplicationFactor = clusterPatchRequest.hasNewReplicationFactor() ? Optional.of(clusterPatchRequest.getNewReplicationFactor()) : Optional.empty();
            return new ClusterConfigurationManagementRequest.ClusterPatchRequest(clusterPatchRequest.getMembersToAddList().stream().map(MemberId::from).collect(Collectors.toSet()), clusterPatchRequest.getMembersToRemoveList().stream().map(MemberId::from).collect(Collectors.toSet()), newPartitionCount, newReplicationFactor, clusterPatchRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public ClusterConfigurationManagementRequest.ForceRemoveBrokersRequest decodeForceRemoveBrokersRequest(byte[] encodedRequest) {
        try {
            Requests.ForceRemoveBrokersRequest forceRemoveBrokersRequest = Requests.ForceRemoveBrokersRequest.parseFrom(encodedRequest);
            return new ClusterConfigurationManagementRequest.ForceRemoveBrokersRequest(forceRemoveBrokersRequest.getMembersToRemoveList().stream().map(MemberId::from).collect(Collectors.toSet()), forceRemoveBrokersRequest.getDryRun());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public byte[] encodeResponse(ClusterConfigurationChangeResponse response) {
        return Requests.Response.newBuilder().setTopologyChangeResponse(this.encodeTopologyChangeResponse(response)).build().toByteArray();
    }

    @Override
    public byte[] encodeResponse(ClusterConfiguration response) {
        return Requests.Response.newBuilder().setClusterTopology(this.encodeClusterTopology(response)).build().toByteArray();
    }

    @Override
    public byte[] encodeResponse(ErrorResponse response) {
        return Requests.Response.newBuilder().setError(Requests.ErrorResponse.newBuilder().setErrorCode(this.encodeErrorCode(response.code())).setErrorMessage(response.message())).build().toByteArray();
    }

    @Override
    public Either<ErrorResponse, ClusterConfigurationChangeResponse> decodeTopologyChangeResponse(byte[] encodedResponse) {
        try {
            Requests.Response response = Requests.Response.parseFrom(encodedResponse);
            if (response.hasError()) {
                return Either.left((Object)new ErrorResponse(this.decodeErrorCode(response.getError().getErrorCode()), response.getError().getErrorMessage()));
            }
            if (response.hasTopologyChangeResponse()) {
                return Either.right((Object)this.decodeTopologyChangeResponse(response.getTopologyChangeResponse()));
            }
            throw new DecodingFailed("Response does not have an error or a valid topology change response");
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    @Override
    public Either<ErrorResponse, ClusterConfiguration> decodeClusterTopologyResponse(byte[] encodedResponse) {
        try {
            Requests.Response response = Requests.Response.parseFrom(encodedResponse);
            if (response.hasError()) {
                return Either.left((Object)new ErrorResponse(this.decodeErrorCode(response.getError().getErrorCode()), response.getError().getErrorMessage()));
            }
            if (response.hasClusterTopology()) {
                return Either.right((Object)this.decodeClusterTopology(response.getClusterTopology()));
            }
            throw new DecodingFailed("Response does not have an error or a valid cluster topology");
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecodingFailed(e);
        }
    }

    public Requests.TopologyChangeResponse.Builder encodeTopologyChangeResponse(ClusterConfigurationChangeResponse clusterConfigurationChangeResponse) {
        Requests.TopologyChangeResponse.Builder builder = Requests.TopologyChangeResponse.newBuilder();
        builder.setChangeId(clusterConfigurationChangeResponse.changeId()).addAllPlannedChanges(clusterConfigurationChangeResponse.plannedChanges().stream().map(this::encodeOperation).toList()).putAllCurrentTopology(this.encodeMemberStateMap(clusterConfigurationChangeResponse.currentConfiguration())).putAllExpectedTopology(this.encodeMemberStateMap(clusterConfigurationChangeResponse.expectedConfiguration()));
        return builder;
    }

    public ClusterConfigurationChangeResponse decodeTopologyChangeResponse(Requests.TopologyChangeResponse topologyChangeResponse) {
        return new ClusterConfigurationChangeResponse(topologyChangeResponse.getChangeId(), this.decodeMemberStateMap(topologyChangeResponse.getCurrentTopologyMap()), this.decodeMemberStateMap(topologyChangeResponse.getExpectedTopologyMap()), topologyChangeResponse.getPlannedChangesList().stream().map(this::decodeOperation).toList());
    }

    private Requests.ErrorCode encodeErrorCode(ErrorResponse.ErrorCode status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ErrorResponse.ErrorCode.INVALID_REQUEST -> Requests.ErrorCode.INVALID_REQUEST;
            case ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED -> Requests.ErrorCode.OPERATION_NOT_ALLOWED;
            case ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION -> Requests.ErrorCode.CONCURRENT_MODIFICATION;
            case ErrorResponse.ErrorCode.INTERNAL_ERROR -> Requests.ErrorCode.INTERNAL_ERROR;
        };
    }

    private ErrorResponse.ErrorCode decodeErrorCode(Requests.ErrorCode status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case Requests.ErrorCode.INVALID_REQUEST -> ErrorResponse.ErrorCode.INVALID_REQUEST;
            case Requests.ErrorCode.OPERATION_NOT_ALLOWED -> ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED;
            case Requests.ErrorCode.CONCURRENT_MODIFICATION -> ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION;
            case Requests.ErrorCode.INTERNAL_ERROR, Requests.ErrorCode.UNRECOGNIZED -> ErrorResponse.ErrorCode.INTERNAL_ERROR;
        };
    }

    private Map<String, Topology.MemberState> encodeMemberStateMap(Map<MemberId, MemberState> topologyChangeResponse) {
        return topologyChangeResponse.entrySet().stream().collect(Collectors.toMap(e -> (String)((Object)((MemberId)e.getKey()).id()), e -> this.encodeMemberState((MemberState)e.getValue())));
    }

    private Topology.ChangeStatus fromTopologyChangeStatus(ClusterChangePlan.Status status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case ClusterChangePlan.Status.IN_PROGRESS -> Topology.ChangeStatus.IN_PROGRESS;
            case ClusterChangePlan.Status.COMPLETED -> Topology.ChangeStatus.COMPLETED;
            case ClusterChangePlan.Status.FAILED -> Topology.ChangeStatus.FAILED;
            case ClusterChangePlan.Status.CANCELLED -> Topology.ChangeStatus.CANCELLED;
        };
    }

    private ClusterChangePlan.Status toChangeStatus(Topology.ChangeStatus status) {
        return switch (status) {
            case Topology.ChangeStatus.IN_PROGRESS -> ClusterChangePlan.Status.IN_PROGRESS;
            case Topology.ChangeStatus.COMPLETED -> ClusterChangePlan.Status.COMPLETED;
            case Topology.ChangeStatus.FAILED -> ClusterChangePlan.Status.FAILED;
            case Topology.ChangeStatus.CANCELLED -> ClusterChangePlan.Status.CANCELLED;
            default -> throw new IllegalStateException("Unknown status: " + String.valueOf((Object)status));
        };
    }
}

