/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.DynamicPartitionConfig;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.Map;
import java.util.function.UnaryOperator;

public class PartitionBootstrapApplier
implements ConfigurationChangeAppliers.MemberOperationApplier {
    private final int partitionId;
    private final int priority;
    private final MemberId memberId;
    private final PartitionChangeExecutor partitionChangeExecutor;
    private DynamicPartitionConfig partitionConfig;

    public PartitionBootstrapApplier(int partitionId, int priority, MemberId memberId, PartitionChangeExecutor partitionChangeExecutor) {
        this.partitionId = partitionId;
        this.priority = priority;
        this.memberId = memberId;
        this.partitionChangeExecutor = partitionChangeExecutor;
    }

    @Override
    public MemberId memberId() {
        return this.memberId;
    }

    @Override
    public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
        if ((long)this.partitionId > 8192L) {
            return Either.left((Object)new IllegalArgumentException("Failed to bootstrap partition '{}'. Partition ID is greater than the maximum allowed partition ID '{}'".formatted(this.partitionId, 8192L)));
        }
        if (!this.isLocalMemberIsActive(currentClusterConfiguration)) {
            return Either.left((Object)new IllegalStateException("Expected to bootstrap partition, but the member '{}' is not active".formatted(this.memberId)));
        }
        if (this.isPartitionAlreadyBootstrapping(currentClusterConfiguration)) {
            return Either.right(UnaryOperator.identity());
        }
        if (this.partitionExists(currentClusterConfiguration)) {
            return Either.left((Object)new IllegalStateException("Failed to bootstrap partition '{}'. Partition already exists in the cluster".formatted(this.partitionId)));
        }
        if (!this.isPartitionIdContiguous(currentClusterConfiguration, this.partitionId)) {
            return Either.left((Object)new IllegalStateException("Failed to bootstrap partition '{}'. Partition ID is not contiguous".formatted(this.partitionId)));
        }
        this.partitionConfig = ((PartitionState)((Map.Entry)currentClusterConfiguration.members().values().stream().flatMap(m -> m.partitions().entrySet().stream().filter(p -> (Integer)p.getKey() == 1)).findFirst().get()).getValue()).config();
        return Either.right(memberState -> memberState.addPartition(this.partitionId, PartitionState.bootstrapping(this.priority, this.partitionConfig)));
    }

    @Override
    public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
        CompletableActorFuture result = new CompletableActorFuture();
        this.partitionChangeExecutor.bootstrap(this.partitionId, this.priority, this.partitionConfig).onComplete((ignore, error) -> {
            if (error == null) {
                result.complete(memberState -> memberState.updatePartition(this.partitionId, PartitionState::toActive));
            } else {
                result.completeExceptionally(error);
            }
        });
        return result;
    }

    private boolean isLocalMemberIsActive(ClusterConfiguration currentClusterConfiguration) {
        return currentClusterConfiguration.hasMember(this.memberId) && currentClusterConfiguration.getMember(this.memberId).state() == MemberState.State.ACTIVE;
    }

    private boolean isPartitionIdContiguous(ClusterConfiguration currentClusterConfiguration, int partitionId) {
        Integer lastPartitionId = currentClusterConfiguration.members().values().stream().flatMap(m -> m.partitions().keySet().stream()).max(Integer::compareTo).orElse(0);
        return partitionId == lastPartitionId + 1;
    }

    private boolean isPartitionAlreadyBootstrapping(ClusterConfiguration currentClusterConfiguration) {
        MemberState member = currentClusterConfiguration.getMember(this.memberId);
        return member.hasPartition(this.partitionId) && member.getPartition(this.partitionId).state() == PartitionState.State.BOOTSTRAPPING;
    }

    private boolean partitionExists(ClusterConfiguration currentClusterConfiguration) {
        return currentClusterConfiguration.members().values().stream().anyMatch(memberState -> memberState.hasPartition(this.partitionId));
    }
}

