/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ClusterMembershipChangeExecutor;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeAppliers;
import io.camunda.zeebe.dynamic.config.changes.MemberJoinApplier;
import io.camunda.zeebe.dynamic.config.changes.MemberLeaveApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionBootstrapApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionChangeExecutor;
import io.camunda.zeebe.dynamic.config.changes.PartitionDisableExporterApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionEnableExporterApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionForceReconfigureApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionJoinApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionLeaveApplier;
import io.camunda.zeebe.dynamic.config.changes.PartitionReconfigurePriorityApplier;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.UnaryOperator;

public class ConfigurationChangeAppliersImpl
implements ConfigurationChangeAppliers {
    private final PartitionChangeExecutor partitionChangeExecutor;
    private final ClusterMembershipChangeExecutor clusterMembershipChangeExecutor;

    public ConfigurationChangeAppliersImpl(PartitionChangeExecutor partitionChangeExecutor, ClusterMembershipChangeExecutor clusterMembershipChangeExecutor) {
        this.partitionChangeExecutor = partitionChangeExecutor;
        this.clusterMembershipChangeExecutor = clusterMembershipChangeExecutor;
    }

    @Override
    public ConfigurationChangeAppliers.ClusterOperationApplier getApplier(ClusterConfigurationChangeOperation operation) {
        ClusterConfigurationChangeOperation clusterConfigurationChangeOperation = operation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation.class, ClusterConfigurationChangeOperation.MemberJoinOperation.class, ClusterConfigurationChangeOperation.MemberLeaveOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation.class, ClusterConfigurationChangeOperation.MemberRemoveOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation.class, ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation.class}, (Object)clusterConfigurationChangeOperation, n)) {
            case 0 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation joinOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation)clusterConfigurationChangeOperation;
                yield new PartitionJoinApplier(joinOperation.partitionId(), joinOperation.priority(), joinOperation.memberId(), this.partitionChangeExecutor);
            }
            case 1 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation leaveOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation)clusterConfigurationChangeOperation;
                yield new PartitionLeaveApplier(leaveOperation.partitionId(), leaveOperation.memberId(), this.partitionChangeExecutor);
            }
            case 2 -> {
                ClusterConfigurationChangeOperation.MemberJoinOperation memberJoinOperation = (ClusterConfigurationChangeOperation.MemberJoinOperation)clusterConfigurationChangeOperation;
                yield new MemberJoinApplier(memberJoinOperation.memberId(), this.clusterMembershipChangeExecutor);
            }
            case 3 -> {
                ClusterConfigurationChangeOperation.MemberLeaveOperation memberLeaveOperation = (ClusterConfigurationChangeOperation.MemberLeaveOperation)clusterConfigurationChangeOperation;
                yield new MemberLeaveApplier(memberLeaveOperation.memberId(), this.clusterMembershipChangeExecutor);
            }
            case 4 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation reconfigurePriorityOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionReconfigurePriorityOperation)clusterConfigurationChangeOperation;
                yield new PartitionReconfigurePriorityApplier(reconfigurePriorityOperation.partitionId(), reconfigurePriorityOperation.priority(), reconfigurePriorityOperation.memberId(), this.partitionChangeExecutor);
            }
            case 5 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation forceReconfigureOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionForceReconfigureOperation)clusterConfigurationChangeOperation;
                yield new PartitionForceReconfigureApplier(forceReconfigureOperation.partitionId(), forceReconfigureOperation.memberId(), forceReconfigureOperation.members(), this.partitionChangeExecutor);
            }
            case 6 -> {
                ClusterConfigurationChangeOperation.MemberRemoveOperation memberRemoveOperation = (ClusterConfigurationChangeOperation.MemberRemoveOperation)clusterConfigurationChangeOperation;
                yield new MemberLeaveApplier(memberRemoveOperation.memberToRemove(), this.clusterMembershipChangeExecutor);
            }
            case 7 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation disableExporterOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionDisableExporterOperation)clusterConfigurationChangeOperation;
                yield new PartitionDisableExporterApplier(disableExporterOperation.partitionId(), disableExporterOperation.memberId(), disableExporterOperation.exporterId(), this.partitionChangeExecutor);
            }
            case 8 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation enableExporterOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation)clusterConfigurationChangeOperation;
                yield new PartitionEnableExporterApplier(enableExporterOperation.partitionId(), enableExporterOperation.memberId(), enableExporterOperation.exporterId(), enableExporterOperation.initializeFrom(), this.partitionChangeExecutor);
            }
            case 9 -> {
                ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation bootstrapOperation = (ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionBootstrapOperation)clusterConfigurationChangeOperation;
                yield new PartitionBootstrapApplier(bootstrapOperation.partitionId(), bootstrapOperation.priority(), bootstrapOperation.memberId(), this.partitionChangeExecutor);
            }
            default -> new FailingApplier(operation);
        };
    }

    static class FailingApplier
    implements ConfigurationChangeAppliers.MemberOperationApplier {
        private final ClusterConfigurationChangeOperation operation;

        public FailingApplier(ClusterConfigurationChangeOperation operation) {
            this.operation = operation;
        }

        @Override
        public MemberId memberId() {
            return this.operation.memberId();
        }

        @Override
        public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration currentClusterConfiguration) {
            return Either.left((Object)new UnknownOperationException(this.operation));
        }

        @Override
        public ActorFuture<UnaryOperator<MemberState>> applyOperation() {
            return CompletableActorFuture.completedExceptionally((Throwable)new UnknownOperationException(this.operation));
        }

        private static class UnknownOperationException
        extends RuntimeException {
            public UnknownOperationException(ClusterConfigurationChangeOperation operation) {
                super("Unknown configuration change operation " + String.valueOf(operation));
            }
        }
    }
}

