/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.changes;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.function.UnaryOperator;

@FunctionalInterface
public interface ConfigurationChangeAppliers {
    public ClusterOperationApplier getApplier(ClusterConfigurationChangeOperation var1);

    public static interface MemberOperationApplier
    extends ClusterOperationApplier {
        @Override
        default public Either<Exception, UnaryOperator<ClusterConfiguration>> init(ClusterConfiguration currentClusterConfiguration) {
            return this.initMemberState(currentClusterConfiguration).map(transformer -> cluster -> cluster.updateMember(this.memberId(), (UnaryOperator<MemberState>)transformer));
        }

        @Override
        default public ActorFuture<UnaryOperator<ClusterConfiguration>> apply() {
            CompletableActorFuture future = new CompletableActorFuture();
            this.applyOperation().onComplete((transformer, error) -> {
                if (error == null) {
                    future.complete(cluster -> cluster.updateMember(this.memberId(), (UnaryOperator<MemberState>)transformer));
                } else {
                    future.completeExceptionally(error);
                }
            });
            return future;
        }

        public MemberId memberId();

        public Either<Exception, UnaryOperator<MemberState>> initMemberState(ClusterConfiguration var1);

        public ActorFuture<UnaryOperator<MemberState>> applyOperation();
    }

    public static interface ClusterOperationApplier {
        public Either<Exception, UnaryOperator<ClusterConfiguration>> init(ClusterConfiguration var1);

        public ActorFuture<UnaryOperator<ClusterConfiguration>> apply();
    }
}

