/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.api.AddMembersTransformer;
import io.camunda.zeebe.dynamic.config.api.PartitionReassignRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.RemoveMembersTransformer;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ScaleRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final Set<MemberId> members;
    private final Optional<Integer> newReplicationFactor;
    private final Optional<Integer> newPartitionCount;
    private final ArrayList<ClusterConfigurationChangeOperation> generatedOperations = new ArrayList();

    public ScaleRequestTransformer(Set<MemberId> members) {
        this(members, Optional.empty());
    }

    public ScaleRequestTransformer(Set<MemberId> members, Optional<Integer> newReplicationFactor) {
        this(members, newReplicationFactor, Optional.empty());
    }

    public ScaleRequestTransformer(Set<MemberId> members, Optional<Integer> newReplicationFactor, Optional<Integer> newPartitionCount) {
        this.members = members;
        this.newReplicationFactor = newReplicationFactor;
        this.newPartitionCount = newPartitionCount;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        this.generatedOperations.clear();
        return new AddMembersTransformer(this.members).operations(clusterConfiguration).map(this::addToOperations).flatMap(ignore -> new PartitionReassignRequestTransformer(this.members, this.newReplicationFactor, this.newPartitionCount).operations(clusterConfiguration)).map(this::addToOperations).flatMap(ignore -> {
            Set<MemberId> membersToRemove = clusterConfiguration.members().keySet().stream().filter(m -> !this.members.contains(m)).collect(Collectors.toSet());
            return new RemoveMembersTransformer(membersToRemove).operations(clusterConfiguration);
        }).map(this::addToOperations);
    }

    private ArrayList<ClusterConfigurationChangeOperation> addToOperations(List<ClusterConfigurationChangeOperation> reassignOperations) {
        this.generatedOperations.addAll(reassignOperations);
        return this.generatedOperations;
    }
}

