/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.dynamic.config.state.MemberState;
import io.camunda.zeebe.dynamic.config.state.PartitionState;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

final class ExporterEnableRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final String exporterId;
    private final Optional<String> initializeFrom;

    public ExporterEnableRequestTransformer(String exporterId, Optional<String> initializeFrom) {
        this.exporterId = exporterId;
        this.initializeFrom = initializeFrom;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        ArrayList<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation> operations = new ArrayList<ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation>();
        for (Map.Entry<MemberId, MemberState> member : clusterConfiguration.members().entrySet()) {
            MemberId memberId = member.getKey();
            for (Map.Entry<Integer, PartitionState> partitions : member.getValue().partitions().entrySet()) {
                Integer partitionId = partitions.getKey();
                operations.add(new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionEnableExporterOperation(memberId, partitionId, this.exporterId, this.initializeFrom));
            }
        }
        return Either.right(operations);
    }
}

