/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.api.ScaleRequestTransformer;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class ClusterScaleRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final Optional<Integer> newClusterSize;
    private final Optional<Integer> newPartitionCount;
    private final Optional<Integer> newReplicationFactor;

    public ClusterScaleRequestTransformer(Optional<Integer> newClusterSize, Optional<Integer> newPartitionCount, Optional<Integer> newReplicationFactor) {
        this.newClusterSize = newClusterSize;
        this.newPartitionCount = newPartitionCount;
        this.newReplicationFactor = newReplicationFactor;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        if (this.newClusterSize.isEmpty() && this.newPartitionCount.isEmpty() && this.newReplicationFactor.isEmpty()) {
            return Either.right(List.of());
        }
        Set<MemberId> newSetOfMembers = IntStream.range(0, this.newClusterSize.orElse(clusterConfiguration.members().size())).mapToObj(i -> MemberId.from((String)String.valueOf(i))).collect(Collectors.toSet());
        return new ScaleRequestTransformer(newSetOfMembers, this.newReplicationFactor, this.newPartitionCount).operations(clusterConfiguration);
    }
}

