/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestFailedException;
import io.camunda.zeebe.dynamic.config.api.ScaleRequestTransformer;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.util.Either;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class ClusterPatchRequestTransformer
implements ConfigurationChangeCoordinator.ConfigurationChangeRequest {
    private final Set<MemberId> membersToAdd;
    private final Set<MemberId> membersToRemove;
    private final Optional<Integer> newPartitionCount;
    private final Optional<Integer> newReplicationFactor;

    public ClusterPatchRequestTransformer(Set<MemberId> membersToAdd, Set<MemberId> membersToRemove, Optional<Integer> newPartitionCount, Optional<Integer> newReplicationFactor) {
        this.membersToAdd = membersToAdd;
        this.membersToRemove = membersToRemove;
        this.newPartitionCount = newPartitionCount;
        this.newReplicationFactor = newReplicationFactor;
    }

    @Override
    public Either<Exception, List<ClusterConfigurationChangeOperation>> operations(ClusterConfiguration clusterConfiguration) {
        if (this.membersToAdd.stream().anyMatch(this.membersToRemove::contains)) {
            return Either.left((Object)new ClusterConfigurationRequestFailedException.InvalidRequest(new IllegalArgumentException("Cannot add and remove the same member in the same request")));
        }
        HashSet<MemberId> newSetOfMembers = new HashSet<MemberId>(clusterConfiguration.members().keySet());
        newSetOfMembers.addAll(this.membersToAdd);
        newSetOfMembers.removeAll(this.membersToRemove);
        return new ScaleRequestTransformer(newSetOfMembers, this.newReplicationFactor, this.newPartitionCount).operations(clusterConfiguration);
    }
}

