/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationChangeResponse;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationManagementApi;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationManagementRequest;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestFailedException;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestTopics;
import io.camunda.zeebe.dynamic.config.api.ErrorResponse;
import io.camunda.zeebe.dynamic.config.serializer.ClusterConfigurationRequestsSerializer;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;

public final class ClusterConfigurationRequestServer
implements AutoCloseable {
    private final ClusterConfigurationManagementApi clusterConfigurationManagementApi;
    private final ClusterCommunicationService communicationService;
    private final ClusterConfigurationRequestsSerializer serializer;

    public ClusterConfigurationRequestServer(ClusterCommunicationService communicationService, ClusterConfigurationRequestsSerializer serializer, ClusterConfigurationManagementApi configurationManagementApi) {
        this.clusterConfigurationManagementApi = configurationManagementApi;
        this.communicationService = communicationService;
        this.serializer = serializer;
    }

    public void start() {
        this.registerAddMemberRequestsHandler();
        this.registerRemoveMemberRequestsHandler();
        this.registerJoinPartitionRequestsHandler();
        this.registerLeavePartitionRequestsHandler();
        this.registerReassignPartitionRequestHandler();
        this.registerScaleRequestHandler();
        this.registerGetTopologyQueryHandler();
        this.registerTopologyCancelHandler();
        this.registerForceScaleDownHandler();
        this.registerDisableExporterHandler();
        this.registerEnableExporterHandler();
        this.registerClusterScaleRequestHandler();
        this.registerClusterPatchRequestHandler();
        this.registerForceRemoveBrokersRequestHandler();
    }

    @Override
    public void close() {
        Stream.of(ClusterConfigurationRequestTopics.values()).toList().forEach(topic -> this.communicationService.unsubscribe(topic.topic()));
    }

    private void registerAddMemberRequestsHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.ADD_MEMBER.topic(), this.serializer::decodeAddMembersRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.addMembers((ClusterConfigurationManagementRequest.AddMembersRequest)request)), this::encodeResponse);
    }

    byte[] encodeResponse(Either<ErrorResponse, ClusterConfigurationChangeResponse> response) {
        if (response.isLeft()) {
            return this.serializer.encodeResponse((ErrorResponse)response.getLeft());
        }
        return this.serializer.encodeResponse((ClusterConfigurationChangeResponse)response.get());
    }

    byte[] encodeClusterTopologyResponse(Either<ErrorResponse, ClusterConfiguration> response) {
        if (response.isLeft()) {
            return this.serializer.encodeResponse((ErrorResponse)response.getLeft());
        }
        return this.serializer.encodeResponse((ClusterConfiguration)response.get());
    }

    private void registerRemoveMemberRequestsHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.REMOVE_MEMBER.topic(), this.serializer::decodeRemoveMembersRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.removeMembers((ClusterConfigurationManagementRequest.RemoveMembersRequest)request)), this::encodeResponse);
    }

    private void registerJoinPartitionRequestsHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.JOIN_PARTITION.topic(), this.serializer::decodeJoinPartitionRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.joinPartition((ClusterConfigurationManagementRequest.JoinPartitionRequest)request)), this::encodeResponse);
    }

    private void registerLeavePartitionRequestsHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.LEAVE_PARTITION.topic(), this.serializer::decodeLeavePartitionRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.leavePartition((ClusterConfigurationManagementRequest.LeavePartitionRequest)request)), this::encodeResponse);
    }

    private void registerReassignPartitionRequestHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.REASSIGN_PARTITIONS.topic(), this.serializer::decodeReassignPartitionsRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.reassignPartitions((ClusterConfigurationManagementRequest.ReassignPartitionsRequest)request)), this::encodeResponse);
    }

    private void registerScaleRequestHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.SCALE_MEMBERS.topic(), this.serializer::decodeScaleRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.scaleMembers((ClusterConfigurationManagementRequest.BrokerScaleRequest)request)), this::encodeResponse);
    }

    private void registerForceScaleDownHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.FORCE_SCALE_DOWN.topic(), this.serializer::decodeScaleRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.forceScaleDown((ClusterConfigurationManagementRequest.BrokerScaleRequest)request)), this::encodeResponse);
    }

    private void registerGetTopologyQueryHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.QUERY_TOPOLOGY.topic(), Function.identity(), request -> this.mapClusterTopologyResponse(this.clusterConfigurationManagementApi.getTopology()), this::encodeClusterTopologyResponse);
    }

    private void registerTopologyCancelHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.CANCEL_CHANGE.topic(), this.serializer::decodeCancelChangeRequest, request -> this.mapClusterTopologyResponse(this.clusterConfigurationManagementApi.cancelTopologyChange((ClusterConfigurationManagementRequest.CancelChangeRequest)request)), this::encodeClusterTopologyResponse);
    }

    private void registerDisableExporterHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.DISABLE_EXPORTER.topic(), this.serializer::decodeExporterDisableRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.disableExporter((ClusterConfigurationManagementRequest.ExporterDisableRequest)request)), this::encodeResponse);
    }

    private void registerEnableExporterHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.ENABLE_EXPORTER.topic(), this.serializer::decodeExporterEnableRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.enableExporter((ClusterConfigurationManagementRequest.ExporterEnableRequest)request)), this::encodeResponse);
    }

    private void registerForceRemoveBrokersRequestHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.FORCE_REMOVE_BROKERS.topic(), this.serializer::decodeForceRemoveBrokersRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.forceRemoveBrokers((ClusterConfigurationManagementRequest.ForceRemoveBrokersRequest)request)), this::encodeResponse);
    }

    private void registerClusterPatchRequestHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.PATCH_CLUSTER.topic(), this.serializer::decodeClusterPatchRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.patchCluster((ClusterConfigurationManagementRequest.ClusterPatchRequest)request)), this::encodeResponse);
    }

    private void registerClusterScaleRequestHandler() {
        this.communicationService.replyTo(ClusterConfigurationRequestTopics.SCALE_CLUSTER.topic(), this.serializer::decodeClusterScaleRequest, request -> this.mapResponse(this.clusterConfigurationManagementApi.scaleCluster((ClusterConfigurationManagementRequest.ClusterScaleRequest)request)), this::encodeResponse);
    }

    private CompletableFuture<Either<ErrorResponse, ClusterConfigurationChangeResponse>> mapResponse(ActorFuture<ClusterConfigurationChangeResponse> topologyManagementApi) {
        return ((CompletableFuture)topologyManagementApi.toCompletableFuture().thenApply(Either::right)).exceptionally(ClusterConfigurationRequestServer::mapError);
    }

    private CompletableFuture<Either<ErrorResponse, ClusterConfiguration>> mapClusterTopologyResponse(ActorFuture<ClusterConfiguration> topologyManagementApi) {
        return ((CompletableFuture)topologyManagementApi.toCompletableFuture().thenApply(Either::right)).exceptionally(ClusterConfigurationRequestServer::mapError);
    }

    private static <T> Either<ErrorResponse, T> mapError(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClusterConfigurationRequestFailedException.OperationNotAllowed.class, ClusterConfigurationRequestFailedException.InvalidRequest.class, ClusterConfigurationRequestFailedException.ConcurrentModificationException.class}, (Object)throwable3, n)) {
            case 0 -> {
                ClusterConfigurationRequestFailedException.OperationNotAllowed operationNotAllowed = (ClusterConfigurationRequestFailedException.OperationNotAllowed)throwable3;
                yield Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.OPERATION_NOT_ALLOWED, operationNotAllowed.getMessage()));
            }
            case 1 -> {
                ClusterConfigurationRequestFailedException.InvalidRequest invalidRequest = (ClusterConfigurationRequestFailedException.InvalidRequest)throwable3;
                yield Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.INVALID_REQUEST, invalidRequest.getMessage()));
            }
            case 2 -> {
                ClusterConfigurationRequestFailedException.ConcurrentModificationException concurrentModificationException = (ClusterConfigurationRequestFailedException.ConcurrentModificationException)throwable3;
                yield Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.CONCURRENT_MODIFICATION, concurrentModificationException.getMessage()));
            }
            default -> Either.left((Object)new ErrorResponse(ErrorResponse.ErrorCode.INTERNAL_ERROR, throwable.getMessage()));
        };
    }
}

