/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.camunda.zeebe.dynamic.config.api.AddMembersTransformer;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationChangeResponse;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationManagementApi;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationManagementRequest;
import io.camunda.zeebe.dynamic.config.api.ClusterConfigurationRequestFailedException;
import io.camunda.zeebe.dynamic.config.api.ClusterPatchRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.ClusterScaleRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.ExporterDisableRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.ExporterEnableRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.ForceRemoveBrokersRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.ForceScaleDownRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.PartitionReassignRequestTransformer;
import io.camunda.zeebe.dynamic.config.api.RemoveMembersTransformer;
import io.camunda.zeebe.dynamic.config.api.ScaleRequestTransformer;
import io.camunda.zeebe.dynamic.config.changes.ConfigurationChangeCoordinator;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.ClusterConfigurationChangeOperation;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class ClusterConfigurationManagementRequestsHandler
implements ClusterConfigurationManagementApi {
    private final ConfigurationChangeCoordinator coordinator;
    private final ConcurrencyControl executor;
    private final MemberId localMemberId;
    private final boolean enablePartitionScaling;

    public ClusterConfigurationManagementRequestsHandler(ConfigurationChangeCoordinator coordinator, MemberId localMemberId, ConcurrencyControl executor, boolean enablePartitionScaling) {
        this.coordinator = coordinator;
        this.executor = executor;
        this.localMemberId = localMemberId;
        this.enablePartitionScaling = enablePartitionScaling;
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> addMembers(ClusterConfigurationManagementRequest.AddMembersRequest addMembersRequest) {
        return this.handleRequest(addMembersRequest.dryRun(), new AddMembersTransformer(addMembersRequest.members()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> removeMembers(ClusterConfigurationManagementRequest.RemoveMembersRequest removeMembersRequest) {
        return this.handleRequest(removeMembersRequest.dryRun(), new RemoveMembersTransformer(removeMembersRequest.members()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> joinPartition(ClusterConfigurationManagementRequest.JoinPartitionRequest joinPartitionRequest) {
        return this.handleRequest(joinPartitionRequest.dryRun(), ignore -> Either.right(List.of(new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionJoinOperation(joinPartitionRequest.memberId(), joinPartitionRequest.partitionId(), joinPartitionRequest.priority()))));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> leavePartition(ClusterConfigurationManagementRequest.LeavePartitionRequest leavePartitionRequest) {
        return this.handleRequest(leavePartitionRequest.dryRun(), ignore -> Either.right(List.of(new ClusterConfigurationChangeOperation.PartitionChangeOperation.PartitionLeaveOperation(leavePartitionRequest.memberId(), leavePartitionRequest.partitionId()))));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> reassignPartitions(ClusterConfigurationManagementRequest.ReassignPartitionsRequest reassignPartitionsRequest) {
        return this.handleRequest(reassignPartitionsRequest.dryRun(), new PartitionReassignRequestTransformer(reassignPartitionsRequest.members()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> scaleMembers(ClusterConfigurationManagementRequest.BrokerScaleRequest scaleRequest) {
        return this.handleRequest(scaleRequest.dryRun(), new ScaleRequestTransformer(scaleRequest.members(), scaleRequest.newReplicationFactor()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> forceScaleDown(ClusterConfigurationManagementRequest.BrokerScaleRequest forceScaleDownRequest) {
        Optional<Integer> optionalNewReplicationFactor = forceScaleDownRequest.newReplicationFactor();
        if (optionalNewReplicationFactor.isPresent()) {
            ActorFuture failedFuture = this.executor.createFuture();
            String errorMessage = String.format("The replication factor cannot be changed to requested value '%s' during force scale down. It will be automatically changed based on which brokers are removed. Do not provide any replication factor in the request", optionalNewReplicationFactor.get());
            failedFuture.completeExceptionally((Throwable)new ClusterConfigurationRequestFailedException.InvalidRequest(errorMessage));
            return failedFuture;
        }
        return this.handleRequest(forceScaleDownRequest.dryRun(), new ForceScaleDownRequestTransformer(forceScaleDownRequest.members(), this.localMemberId));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> scaleCluster(ClusterConfigurationManagementRequest.ClusterScaleRequest clusterScaleRequest) {
        if (!this.enablePartitionScaling && clusterScaleRequest.newPartitionCount().isPresent()) {
            ActorFuture failedFuture = this.executor.createFuture();
            failedFuture.completeExceptionally((Throwable)new UnsupportedOperationException("Partition scaling is not enabled."));
            return failedFuture;
        }
        return this.handleRequest(clusterScaleRequest.dryRun(), new ClusterScaleRequestTransformer(clusterScaleRequest.newClusterSize(), clusterScaleRequest.newPartitionCount(), clusterScaleRequest.newReplicationFactor()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> patchCluster(ClusterConfigurationManagementRequest.ClusterPatchRequest clusterPatchRequest) {
        if (!this.enablePartitionScaling && clusterPatchRequest.newPartitionCount().isPresent()) {
            ActorFuture failedFuture = this.executor.createFuture();
            failedFuture.completeExceptionally((Throwable)new UnsupportedOperationException("Partition scaling is not enabled."));
            return failedFuture;
        }
        return this.handleRequest(clusterPatchRequest.dryRun(), new ClusterPatchRequestTransformer(clusterPatchRequest.membersToAdd(), clusterPatchRequest.membersToRemove(), clusterPatchRequest.newPartitionCount(), clusterPatchRequest.newReplicationFactor()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> forceRemoveBrokers(ClusterConfigurationManagementRequest.ForceRemoveBrokersRequest forceRemoveBrokersRequest) {
        return this.handleRequest(forceRemoveBrokersRequest.dryRun(), new ForceRemoveBrokersRequestTransformer(forceRemoveBrokersRequest.membersToRemove(), this.localMemberId));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> disableExporter(ClusterConfigurationManagementRequest.ExporterDisableRequest exporterDisableRequest) {
        return this.handleRequest(exporterDisableRequest.dryRun(), new ExporterDisableRequestTransformer(exporterDisableRequest.exporterId()));
    }

    @Override
    public ActorFuture<ClusterConfigurationChangeResponse> enableExporter(ClusterConfigurationManagementRequest.ExporterEnableRequest enableRequest) {
        return this.handleRequest(enableRequest.dryRun(), new ExporterEnableRequestTransformer(enableRequest.exporterId(), enableRequest.initializeFrom()));
    }

    @Override
    public ActorFuture<ClusterConfiguration> cancelTopologyChange(ClusterConfigurationManagementRequest.CancelChangeRequest changeRequest) {
        return this.coordinator.cancelChange(changeRequest.changeId());
    }

    @Override
    public ActorFuture<ClusterConfiguration> getTopology() {
        return this.coordinator.getClusterConfiguration();
    }

    private ActorFuture<ClusterConfigurationChangeResponse> handleRequest(boolean dryRun, ConfigurationChangeCoordinator.ConfigurationChangeRequest request) {
        Function<ConfigurationChangeCoordinator.ConfigurationChangeRequest, ActorFuture> handler = dryRun ? this.coordinator::simulateOperations : this.coordinator::applyOperations;
        return handler.apply(request).thenApply(result -> new ClusterConfigurationChangeResponse(result.changeId(), result.currentConfiguration().members(), result.finalConfiguration().members(), result.operations()), (Executor)this.executor);
    }
}

