/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import java.util.Optional;
import java.util.Set;

public sealed interface ClusterConfigurationManagementRequest {
    public boolean dryRun();

    public record CancelChangeRequest(long changeId) implements ClusterConfigurationManagementRequest
    {
        @Override
        public boolean dryRun() {
            return false;
        }
    }

    public record ExporterEnableRequest(String exporterId, Optional<String> initializeFrom, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record ExporterDisableRequest(String exporterId, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record ForceRemoveBrokersRequest(Set<MemberId> membersToRemove, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record ClusterPatchRequest(Set<MemberId> membersToAdd, Set<MemberId> membersToRemove, Optional<Integer> newPartitionCount, Optional<Integer> newReplicationFactor, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record ClusterScaleRequest(Optional<Integer> newClusterSize, Optional<Integer> newPartitionCount, Optional<Integer> newReplicationFactor, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record BrokerScaleRequest(Set<MemberId> members, Optional<Integer> newReplicationFactor, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
        public BrokerScaleRequest(Set<MemberId> members, boolean dryRun) {
            this(members, Optional.empty(), dryRun);
        }
    }

    public record ReassignPartitionsRequest(Set<MemberId> members, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record LeavePartitionRequest(MemberId memberId, int partitionId, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record JoinPartitionRequest(MemberId memberId, int partitionId, int priority, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record RemoveMembersRequest(Set<MemberId> members, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }

    public record AddMembersRequest(Set<MemberId> members, boolean dryRun) implements ClusterConfigurationManagementRequest
    {
    }
}

