/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.dynamic.config.api;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.NodeId;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public interface ClusterConfigurationCoordinatorSupplier {
    public MemberId getDefaultCoordinator();

    public MemberId getNextCoordinator(Collection<MemberId> var1);

    public MemberId getNextCoordinatorExcluding(Set<MemberId> var1);

    public static class ClusterClusterConfigurationAwareCoordinatorSupplier
    implements ClusterConfigurationCoordinatorSupplier {
        private final Supplier<ClusterConfiguration> clusterTopologySupplier;

        public ClusterClusterConfigurationAwareCoordinatorSupplier(Supplier<ClusterConfiguration> clusterTopologySupplier) {
            this.clusterTopologySupplier = clusterTopologySupplier;
        }

        private MemberId lowestMemberId(Collection<MemberId> members) {
            if (members.isEmpty()) {
                return MemberId.from((String)"0");
            }
            return members.stream().min(NodeId::compareTo).orElseThrow();
        }

        @Override
        public MemberId getDefaultCoordinator() {
            ClusterConfiguration clusterTopology = this.clusterTopologySupplier.get();
            return this.lowestMemberId(clusterTopology.members().keySet());
        }

        @Override
        public MemberId getNextCoordinator(Collection<MemberId> members) {
            return this.lowestMemberId(members);
        }

        @Override
        public MemberId getNextCoordinatorExcluding(Set<MemberId> memberIds) {
            Set<MemberId> currentMembers = this.clusterTopologySupplier.get().members().keySet();
            List<MemberId> newMembers = currentMembers.stream().filter(m -> !memberIds.contains(m)).toList();
            return this.lowestMemberId(newMembers);
        }
    }
}

