/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.MigrateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.MigrationPlan;
import io.camunda.zeebe.client.api.response.MigrateProcessInstanceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.MigrateProcessInstanceResponseImpl;
import io.camunda.zeebe.client.impl.util.ParseUtil;
import io.camunda.zeebe.client.protocol.rest.MigrateProcessInstanceMappingInstruction;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceMigrationInstruction;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.config.RequestConfig;

public final class MigrateProcessInstanceCommandImpl
implements MigrateProcessInstanceCommandStep1,
MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep {
    private final GatewayOuterClass.MigrateProcessInstanceRequest.Builder requestBuilder = GatewayOuterClass.MigrateProcessInstanceRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final ProcessInstanceMigrationInstruction httpRequestObject;
    private boolean useRest;
    private final long processInstanceKey;
    private final JsonMapper jsonMapper;

    public MigrateProcessInstanceCommandImpl(long processInstanceKey, GatewayGrpc.GatewayStub asyncStub, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, ZeebeClientConfiguration config, JsonMapper jsonMapper) {
        this.requestBuilder.setProcessInstanceKey(processInstanceKey);
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new ProcessInstanceMigrationInstruction();
        this.useRest = config.preferRestOverGrpc();
        this.processInstanceKey = processInstanceKey;
        this.jsonMapper = jsonMapper;
        this.requestTimeout(this.requestTimeout);
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep migrationPlan(long targetProcessDefinitionKey) {
        this.requestBuilder.setMigrationPlan(GatewayOuterClass.MigrateProcessInstanceRequest.MigrationPlan.newBuilder().setTargetProcessDefinitionKey(targetProcessDefinitionKey).build());
        this.httpRequestObject.setTargetProcessDefinitionKey(ParseUtil.keyToString(targetProcessDefinitionKey));
        return this;
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep migrationPlan(MigrationPlan migrationPlan) {
        List mappingInstructions = migrationPlan.getMappingInstructions().stream().map(mappingInstruction -> this.buildMappingInstruction(mappingInstruction.getSourceElementId(), mappingInstruction.getTargetElementId())).collect(Collectors.toList());
        this.requestBuilder.setMigrationPlan(GatewayOuterClass.MigrateProcessInstanceRequest.MigrationPlan.newBuilder().setTargetProcessDefinitionKey(migrationPlan.getTargetProcessDefinitionKey()).addAllMappingInstructions(mappingInstructions));
        this.buildRequestObject(migrationPlan);
        return this;
    }

    private void buildRequestObject(MigrationPlan migrationPlan) {
        this.httpRequestObject.setTargetProcessDefinitionKey(ParseUtil.keyToString(migrationPlan.getTargetProcessDefinitionKey()));
        this.httpRequestObject.setMappingInstructions(migrationPlan.getMappingInstructions().stream().map(mappingInstruction -> new MigrateProcessInstanceMappingInstruction().sourceElementId(mappingInstruction.getSourceElementId()).targetElementId(mappingInstruction.getTargetElementId())).collect(Collectors.toList()));
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep addMappingInstruction(String sourceElementId, String targetElementId) {
        this.requestBuilder.getMigrationPlanBuilder().addMappingInstructions(this.buildMappingInstruction(sourceElementId, targetElementId));
        this.httpRequestObject.addMappingInstructionsItem(new MigrateProcessInstanceMappingInstruction().sourceElementId(sourceElementId).targetElementId(targetElementId));
        return this;
    }

    @Override
    public FinalCommandStep<MigrateProcessInstanceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<MigrateProcessInstanceResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<MigrateProcessInstanceResponse> sendRestRequest() {
        HttpZeebeFuture<MigrateProcessInstanceResponse> result = new HttpZeebeFuture<MigrateProcessInstanceResponse>();
        this.httpClient.post("/process-instances/" + this.processInstanceKey + "/migration", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private ZeebeFuture<MigrateProcessInstanceResponse> sendGrpcRequest() {
        GatewayOuterClass.MigrateProcessInstanceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<MigrateProcessInstanceResponse, GatewayOuterClass.MigrateProcessInstanceResponse> future = new RetriableClientFutureImpl<MigrateProcessInstanceResponse, GatewayOuterClass.MigrateProcessInstanceResponse>(MigrateProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.MigrateProcessInstanceResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.MigrateProcessInstanceResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.MigrateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.MigrateProcessInstanceResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).migrateProcessInstance(request, streamObserver);
    }

    private GatewayOuterClass.MigrateProcessInstanceRequest.MappingInstruction buildMappingInstruction(String sourceElementId, String targetElementId) {
        ArgumentUtil.ensureNotNull("sourceElementId", sourceElementId);
        ArgumentUtil.ensureNotNull("targetElementId", targetElementId);
        return GatewayOuterClass.MigrateProcessInstanceRequest.MappingInstruction.newBuilder().setSourceElementId(sourceElementId).setTargetElementId(targetElementId).build();
    }

    @Override
    public MigrateProcessInstanceCommandStep1.MigrateProcessInstanceCommandFinalStep operationReference(long operationReference) {
        this.requestBuilder.setOperationReference(operationReference);
        this.httpRequestObject.setOperationReference(operationReference);
        return this;
    }

    @Override
    public MigrateProcessInstanceCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public MigrateProcessInstanceCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

