/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FailJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.FailJobResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.response.FailJobResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class FailJobCommandImpl
extends CommandWithVariables<FailJobCommandStep1.FailJobCommandStep2>
implements FailJobCommandStep1,
FailJobCommandStep1.FailJobCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.FailJobRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public FailJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.FailJobRequest.newBuilder();
        this.builder.setJobKey(key);
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 retries(int retries) {
        this.builder.setRetries(retries);
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 retryBackoff(Duration backoffTimeout) {
        this.builder.setRetryBackOff(backoffTimeout.toMillis());
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 errorMessage(String errorMsg) {
        this.builder.setErrorMessage(errorMsg);
        return this;
    }

    @Override
    public FailJobCommandStep1.FailJobCommandStep2 setVariablesInternal(String variables) {
        this.builder.setVariables(variables);
        return this;
    }

    @Override
    public FinalCommandStep<FailJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<FailJobResponse> send() {
        GatewayOuterClass.FailJobRequest request = this.builder.build();
        RetriableClientFutureImpl<FailJobResponse, GatewayOuterClass.FailJobResponse> future = new RetriableClientFutureImpl<FailJobResponse, GatewayOuterClass.FailJobResponse>(FailJobResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.FailJobResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.FailJobResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).failJob(request, streamObserver);
    }
}

