/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.impl;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntArrayList;

public final class BrokerClusterStateImpl
implements BrokerClusterState {
    public static final int UNINITIALIZED_CLUSTER_SIZE = -1;
    private static final Long TERM_NONE = -1L;
    private final Int2IntHashMap partitionLeaders = new Int2IntHashMap(-2);
    private final Int2ObjectHashMap<Long> partitionLeaderTerms = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<Set<Integer>> partitionFollowers = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<Set<Integer>> partitionInactiveNodes = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<Int2ObjectHashMap<PartitionHealthStatus>> partitionsHealthPerBroker = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<String> brokerAddresses = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<String> brokerVersions = new Int2ObjectHashMap();
    private final IntArrayList brokers = new IntArrayList(5, -2);
    private final IntArrayList partitions = new IntArrayList(32, -3);
    private final Random randomBroker = new Random();
    private int clusterSize = -1;
    private int partitionsCount;
    private int replicationFactor;

    public BrokerClusterStateImpl(BrokerClusterStateImpl topology) {
        this();
        if (topology != null) {
            this.partitionLeaders.putAll(topology.partitionLeaders);
            this.partitionLeaderTerms.putAll(topology.partitionLeaderTerms);
            this.partitionFollowers.putAll(topology.partitionFollowers);
            this.partitionsHealthPerBroker.putAll(topology.partitionsHealthPerBroker);
            this.brokerAddresses.putAll(topology.brokerAddresses);
            this.brokerVersions.putAll(topology.brokerVersions);
            this.partitionInactiveNodes.putAll(topology.partitionInactiveNodes);
            this.brokers.addAll(topology.brokers);
            this.partitions.addAll(topology.partitions);
            this.clusterSize = topology.clusterSize;
            this.partitionsCount = topology.partitionsCount;
            this.replicationFactor = topology.replicationFactor;
        }
    }

    public BrokerClusterStateImpl() {
    }

    public void setPartitionLeader(int partitionId, int leaderId, long term) {
        if ((Long)this.partitionLeaderTerms.getOrDefault(partitionId, (Object)TERM_NONE) <= term) {
            Set inactives;
            this.partitionLeaders.put(partitionId, leaderId);
            this.partitionLeaderTerms.put(partitionId, (Object)term);
            Set followers = (Set)this.partitionFollowers.get(partitionId);
            if (followers != null) {
                followers.removeIf(follower -> follower == leaderId);
            }
            if ((inactives = (Set)this.partitionInactiveNodes.get(partitionId)) != null) {
                inactives.removeIf(inactive -> inactive == leaderId);
            }
        }
    }

    public void syncPartitions(int nodeId, Set<Integer> partitions) {
        ((Int2ObjectHashMap)this.partitionsHealthPerBroker.getOrDefault(nodeId, (Object)new Int2ObjectHashMap())).keySet().removeIf(Predicate.not(partitions::contains));
        this.partitionLeaders.entrySet().removeIf(entry -> (Integer)entry.getValue() == nodeId && !partitions.contains(entry.getKey()));
        this.partitionFollowers.forEach((partitionId, followers) -> {
            if (!partitions.contains(partitionId)) {
                followers.removeIf(follower -> follower == nodeId);
            }
        });
        this.partitionInactiveNodes.forEach((partitionId, inactives) -> {
            if (!partitions.contains(partitionId)) {
                inactives.removeIf(inactive -> inactive == nodeId);
            }
        });
    }

    public void setPartitionHealthStatus(int brokerId, int partitionId, PartitionHealthStatus status) {
        Int2ObjectHashMap partitionsHealth = (Int2ObjectHashMap)this.partitionsHealthPerBroker.computeIfAbsent(brokerId, integer -> new Int2ObjectHashMap());
        partitionsHealth.put(partitionId, (Object)status);
    }

    public void addPartitionFollower(int partitionId, int followerId) {
        ((Set)this.partitionFollowers.computeIfAbsent(partitionId, HashSet::new)).add(followerId);
        this.partitionLeaders.remove(partitionId, followerId);
        Set inactives = (Set)this.partitionInactiveNodes.get(partitionId);
        if (inactives != null) {
            inactives.remove(followerId);
        }
    }

    public void addPartitionInactive(int partitionId, int brokerId) {
        ((Set)this.partitionInactiveNodes.computeIfAbsent(partitionId, HashSet::new)).add(brokerId);
        this.partitionLeaders.remove(partitionId, brokerId);
        Set followers = (Set)this.partitionFollowers.get(partitionId);
        if (followers != null) {
            followers.remove(brokerId);
        }
    }

    public void addPartitionIfAbsent(int partitionId) {
        if (!this.partitions.contains((Object)partitionId)) {
            this.partitions.addInt(partitionId);
        }
    }

    public boolean addBrokerIfAbsent(int nodeId) {
        if (this.brokerAddresses.get(nodeId) != null) {
            return false;
        }
        this.brokerAddresses.put(nodeId, (Object)"");
        this.brokerVersions.put(nodeId, (Object)"");
        this.brokers.addInt(nodeId);
        return true;
    }

    public void setBrokerAddressIfPresent(int brokerId, String address) {
        this.brokerAddresses.computeIfPresent(brokerId, (k, v) -> address);
    }

    public void setBrokerVersionIfPresent(int brokerId, String version) {
        this.brokerVersions.computeIfPresent(brokerId, (k, v) -> version);
    }

    public void removeBroker(int brokerId) {
        this.brokerAddresses.remove(brokerId);
        this.brokerVersions.remove(brokerId);
        this.brokers.removeInt(brokerId);
        this.partitions.forEachOrderedInt(partitionId -> {
            Set inactive;
            Set followers;
            if (this.partitionLeaders.get(partitionId) == brokerId) {
                this.partitionLeaders.remove(partitionId);
            }
            if ((followers = (Set)this.partitionFollowers.get(partitionId)) != null) {
                followers.remove(brokerId);
            }
            if ((inactive = (Set)this.partitionInactiveNodes.get(partitionId)) != null) {
                inactive.remove(brokerId);
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.clusterSize != -1;
    }

    @Override
    public int getClusterSize() {
        return this.clusterSize;
    }

    public void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    @Override
    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public void setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public int getLeaderForPartition(int partition) {
        return this.partitionLeaders.get(partition);
    }

    @Override
    public Set<Integer> getFollowersForPartition(int partition) {
        return (Set)this.partitionFollowers.get(partition);
    }

    @Override
    public Set<Integer> getInactiveNodesForPartition(int partition) {
        return (Set)this.partitionInactiveNodes.get(partition);
    }

    @Override
    public int getRandomBroker() {
        if (this.brokers.isEmpty()) {
            return -1;
        }
        return this.brokers.get(this.randomBroker.nextInt(this.brokers.size()));
    }

    @Override
    public List<Integer> getPartitions() {
        return this.partitions;
    }

    @Override
    public List<Integer> getBrokers() {
        return this.brokers;
    }

    @Override
    public String getBrokerAddress(int brokerId) {
        return (String)this.brokerAddresses.get(brokerId);
    }

    @Override
    public int getPartition(int index) {
        if (!this.partitions.isEmpty()) {
            return this.partitions.getInt(index % this.partitions.size());
        }
        return -3;
    }

    @Override
    public String getBrokerVersion(int brokerId) {
        return (String)this.brokerVersions.get(brokerId);
    }

    @Override
    public PartitionHealthStatus getPartitionHealth(int brokerId, int partitionId) {
        Int2ObjectHashMap brokerHealthyPartitions = (Int2ObjectHashMap)this.partitionsHealthPerBroker.get(brokerId);
        if (brokerHealthyPartitions == null) {
            return PartitionHealthStatus.UNHEALTHY;
        }
        return (PartitionHealthStatus)brokerHealthyPartitions.getOrDefault(partitionId, (Object)PartitionHealthStatus.UNHEALTHY);
    }

    public String toString() {
        return "BrokerClusterStateImpl{partitionLeaders=" + String.valueOf(this.partitionLeaders) + ", brokers=" + String.valueOf(this.brokers) + ", partitions=" + String.valueOf(this.partitions) + ", clusterSize=" + this.clusterSize + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + "}";
    }
}

